/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;

public class BeforeInsertSupport<TRIGGER, TARGET>
implements InsertListener<TRIGGER> {
    private final Consumer<Iterable<TARGET>> beforeInsertAction;
    private final Function<TRIGGER, TARGET> targetProvider;
    private final Predicate<TARGET> targetFilter;

    public BeforeInsertSupport(Consumer<Iterable<TARGET>> beforeInsertAction, Function<TRIGGER, TARGET> targetProvider) {
        this(beforeInsertAction, targetProvider, Predicates.acceptAll());
    }

    public BeforeInsertSupport(Consumer<Iterable<TARGET>> beforeInsertAction, Function<TRIGGER, TARGET> targetProvider, Predicate<TARGET> targetFilter) {
        this.beforeInsertAction = beforeInsertAction;
        this.targetProvider = targetProvider;
        this.targetFilter = targetFilter;
    }

    public void beforeInsert(Iterable<? extends TRIGGER> entities) {
        this.beforeInsertAction.accept(Iterables.stream(entities).map(this.targetProvider).filter(this.targetFilter).collect(Collectors.toSet()));
    }
}

