/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.util.Map;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterProvider;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderProvider;

public interface ParameterBinderProvider<K>
extends PreparedStatementWriterProvider<K>,
ResultSetReaderProvider<K> {
    default public ParameterBinder getBinder(K key) {
        ParameterBinder binder = this.doGetBinder(key);
        if (binder == null) {
            throw new SQLStatement.BindingException("Binder for " + key + " is not registered");
        }
        return binder;
    }

    public ParameterBinder doGetBinder(K var1);

    @Override
    default public PreparedStatementWriter doGetWriter(K key) {
        return this.doGetBinder(key);
    }

    @Override
    default public ResultSetReader doGetReader(K key) {
        return this.doGetBinder(key);
    }

    public static class ParameterBinderProviderFromMap<ParamType, BINDER extends ParameterBinder>
    implements ParameterBinderProvider<ParamType> {
        private final Map<ParamType, BINDER> parameterBinders;

        public ParameterBinderProviderFromMap(Map<ParamType, BINDER> parameterBinders) {
            this.parameterBinders = parameterBinders;
        }

        public Map<ParamType, BINDER> getParameterBinders() {
            return this.parameterBinders;
        }

        public BINDER doGetBinder(ParamType key) {
            return (BINDER)((ParameterBinder)this.parameterBinders.get(key));
        }
    }
}

