/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

class JdbcForeignKey {
    private final String name;
    private final String srcColumnName;
    private final String srcTableName;
    private final String targetColumnName;
    private final String targetTableName;

    JdbcForeignKey(String name, String srcTableName, String srcColumnName, String targetTableName, String targetColumnName) {
        this.name = name;
        this.srcColumnName = srcColumnName;
        this.srcTableName = srcTableName;
        this.targetColumnName = targetColumnName;
        this.targetTableName = targetTableName;
    }

    public JdbcForeignKey(ForeignKey<? extends Table, ? extends Table, ?> fk) {
        this(fk.getName(), fk.getTable().getName(), ((Column)Iterables.first((Iterable)fk.getColumns())).getName(), fk.getTargetTable().getName(), ((Column)Iterables.first((Iterable)fk.getTargetColumns())).getName());
    }

    public String getName() {
        return this.name;
    }

    public String getSrcColumnName() {
        return this.srcColumnName;
    }

    public String getSrcTableName() {
        return this.srcTableName;
    }

    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    String getSignature() {
        return "JdbcForeignKey{name='" + this.name + '\'' + ", srcTableName='" + this.srcTableName + '\'' + ", srcColumnName='" + this.srcColumnName + '\'' + ", targetTableName='" + this.targetTableName + '\'' + ", targetColumnName='" + this.targetColumnName + '\'' + '}';
    }
}

