/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.UpdateCommandBuilder;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UpdateCommandBuilderTest {
    UpdateCommandBuilderTest() {
    }

    @Test
    void toSQL_singleTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Update update = new Update(totoTable).set(columnA).set(columnB);
        update.where(columnA, (ConditionalOperator)Operators.eq((Object)44)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        Dialect dialect = new Dialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = ?, b = ? where a = 44 or a = b");
        update = new Update(totoTable).set(columnA, columnB);
        testInstance = new UpdateCommandBuilder(update, dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = b");
        update = new Update(totoTable).set(columnA, (Object)"tata");
        testInstance = new UpdateCommandBuilder(update, dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = 'tata'");
    }

    @Test
    void toSQL_multiTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Table tataTable = new Table("Tata");
        Column columnX = tataTable.addColumn("x", Long.class);
        Column columnY = tataTable.addColumn("y", String.class);
        Column columnZ = tataTable.addColumn("z", String.class);
        Update update = new Update(totoTable).set(columnA).set(columnB);
        update.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        Dialect dialect = new Dialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set Toto.a = ?, Toto.b = ? where Toto.a = Tata.x or Toto.a = Tata.y");
        update = new Update(totoTable).set(columnC, columnZ);
        update.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        testInstance = new UpdateCommandBuilder(update, dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set Toto.c = Tata.z where Toto.a = Tata.x or Toto.a = Tata.y");
    }

    @Test
    void toStatement() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", String.class);
        Update update = new Update(totoTable).set(columnA).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD);
        update.where(columnA, (ConditionalOperator)Operators.in((Object[])new Long[]{42L, 43L})).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        Dialect dialect = new Dialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, dialect);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("update Toto set a = ?, b = a, c = ?, d = ? where a in (?, ?) or a = b");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)2, (Object)"tata").add((Object)4, (Object)42L).add((Object)5, (Object)43L));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)4)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)5)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        result.setValue(columnA, (Object)41L);
        result.setValue(columnD, (Object)"toto");
        PreparedStatement mock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, 41L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(3, "toto");
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(4, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(5, 43L);
        result.setValue(columnC, (Object)"tutu");
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(2, "tutu");
        dialect.getColumnBinderRegistry().register(columnA, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result = testInstance.toStatement();
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result.setValue(columnA, (Object)-42L);
        result.setValue(columnD, (Object)"toto");
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, -42L);
    }
}

