/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.postgresql.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.tool.exception.Exceptions;

public class PostgreSQLDatabaseHelper
extends DatabaseHelper {
    protected ResultSetIterator<String> lookupTables(Connection connection) {
        ResultSet tablesResultSet;
        try {
            PreparedStatement getCurrentSchemaStatement = connection.prepareStatement("select current_schema()");
            ResultSet resultSet = getCurrentSchemaStatement.executeQuery();
            resultSet.next();
            String currentSchema = resultSet.getString(1);
            tablesResultSet = connection.getMetaData().getTables(null, currentSchema, null, new String[]{"TABLE"});
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        return new ResultSetIterator<String>(tablesResultSet){

            public String convert(ResultSet resultSet) throws SQLException {
                int table_name = resultSet.findColumn("TABLE_NAME");
                return resultSet.getString(table_name);
            }
        };
    }
}

