/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.derby.statement.binder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.DefaultPreparedStatementWriters;
import org.codefilarete.stalactite.sql.statement.binder.InMemoryBlobSupport;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.LocalTimeBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwarePreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.function.SerializableThrowingTriConsumer;
import org.codefilarete.tool.io.IOs;

public final class DerbyParameterBinders {
    public static final ParameterBinder<InputStream> BINARYSTREAM_BINDER = new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> (ByteArrayInputStream)Nullable.nullable((Object)resultSet.getBinaryStream((String)columnName)).mapThrower(inputStream -> {
        try {
            return IOs.toByteArrayInputStream((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }).get(), InputStream.class), DefaultPreparedStatementWriters.BINARYSTREAM_WRITER);
    public static final ParameterBinder<byte[]> BYTES_BINDER = new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> (byte[])Nullable.nullable((Object)resultSet.getBytes((String)columnName)).mapThrower(bytes -> Arrays.copyOf(bytes, ((byte[])bytes).length)).get(), byte[].class), DefaultPreparedStatementWriters.BYTES_WRITER);
    public static final ParameterBinder<Blob> BLOB_BINDER = new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> (InMemoryBlobSupport)Nullable.nullable((Object)resultSet.getBlob((String)columnName)).mapThrower(blob -> new InMemoryBlobSupport(blob.getBytes(1L, (int)blob.length()))).get(), Blob.class), DefaultPreparedStatementWriters.BLOB_WRITER);
    public static final ParameterBinder<LocalDateTime> LOCALDATETIME_BINDER = new NullAwareParameterBinder(new NullAwareResultSetReader((ResultSetReader)DefaultParameterBinders.LOCALDATETIME_BINDER), new NullAwarePreparedStatementWriter((SerializableThrowingTriConsumer & Serializable)(preparedStatement, valueIndex, localDateTime) -> {
        localDateTime = localDateTime.minusNanos(localDateTime.getNano() % 1000);
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        preparedStatement.setTimestamp((int)valueIndex, timestamp);
    }));
    public static final ParameterBinder<LocalTime> LOCALTIME_BINDER = new NullAwareParameterBinder(new NullAwareResultSetReader((ResultSetReader)DefaultParameterBinders.LOCALTIME_BINDER), new NullAwarePreparedStatementWriter((SerializableThrowingTriConsumer & Serializable)(preparedStatement, valueIndex, localDateTime) -> {
        localDateTime = localDateTime.minusNanos(localDateTime.getNano() % 1000);
        Timestamp timestamp = Timestamp.valueOf(localDateTime.atDate(LocalTimeBinder.DEFAULT_TIMESTAMP_REFERENCE_DATE));
        preparedStatement.setTimestamp((int)valueIndex, timestamp);
    }));

    private DerbyParameterBinders() {
    }
}

