/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.codefilarete.stalactite.spring.repository.config.EnableStalactiteRepositories;
import org.codefilarete.stalactite.spring.repository.config.StalactiteRepositoryConfigExtension;
import org.springframework.boot.autoconfigure.data.AbstractRepositoryConfigurationSourceSupport;
import org.springframework.core.env.Environment;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.util.StringUtils;

class StalactiteRepositoriesRegistrar
extends AbstractRepositoryConfigurationSourceSupport {
    private BootstrapMode bootstrapMode = null;

    StalactiteRepositoriesRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableStalactiteRepositories.class;
    }

    protected Class<?> getConfiguration() {
        return EnableStalactiteRepositoriesConfiguration.class;
    }

    protected RepositoryConfigurationExtension getRepositoryConfigurationExtension() {
        return new StalactiteRepositoryConfigExtension();
    }

    protected BootstrapMode getBootstrapMode() {
        return this.bootstrapMode == null ? BootstrapMode.DEFAULT : this.bootstrapMode;
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.configureBootstrapMode(environment);
    }

    private void configureBootstrapMode(Environment environment) {
        String property = environment.getProperty("spring.data.stalactite.repositories.bootstrap-mode");
        if (StringUtils.hasText((String)property)) {
            this.bootstrapMode = BootstrapMode.valueOf((String)property.toUpperCase(Locale.ENGLISH));
        }
    }

    @EnableStalactiteRepositories
    private static class EnableStalactiteRepositoriesConfiguration {
        private EnableStalactiteRepositoriesConfiguration() {
        }
    }
}

