/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class SimpleBeanCache {
    private final Map<Class, Map<BeanKey, Object>> entityCache;

    public SimpleBeanCache() {
        this(new HashMap<Class, Map<BeanKey, Object>>());
    }

    public SimpleBeanCache(Map<Class, Map<BeanKey, Object>> entityCache) {
        this.entityCache = entityCache;
    }

    public void clear() {
        this.entityCache.clear();
    }

    public <C, I> C computeIfAbsent(Class<C> clazz, @Nonnull I identifier, Function<I, C> factory) {
        BeanKey key = identifier.getClass().isArray() ? new BeanKey((Object[])identifier) : new BeanKey(new Object[]{identifier});
        Object rowInstance = this.entityCache.computeIfAbsent(clazz, k -> new HashMap()).get(key);
        if (rowInstance == null) {
            rowInstance = factory.apply(identifier);
            this.entityCache.computeIfAbsent(clazz, k -> new HashMap()).put(key, rowInstance);
        }
        return (C)rowInstance;
    }

    private static class BeanKey {
        private final Object[] keys;
        private final int hashCode;

        private BeanKey(Object ... keys) {
            this.keys = keys;
            this.hashCode = Arrays.hashCode(keys);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeanKey)) {
                return false;
            }
            BeanKey beanKey = (BeanKey)o;
            return Arrays.equals(this.keys, beanKey.keys);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

