/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.ToBeanRowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class ToBeanRowTransformerTest {
    ToBeanRowTransformerTest() {
    }

    @Test
    public void testTransform_defaultCase() {
        Table table = new Table("totoTable");
        Column columnA = table.addColumn("a", Integer.TYPE);
        Column columnB = table.addColumn("b", String.class);
        ToBeanRowTransformer testInstance = new ToBeanRowTransformer(Toto.class, (Map)Maps.forHashMap(Column.class, Mutator.class).add((Object)columnA, (Object)Accessors.mutatorByMethodReference(Toto::setProp1)).add((Object)columnB, (Object)Accessors.mutatorByMethodReference(Toto::setProp2)));
        Row row = new Row();
        row.add(columnA.getName(), (Object)1);
        row.add(columnB.getName(), (Object)"hello");
        Toto transform = (Toto)testInstance.transform(row);
        Assertions.assertThat((int)transform.prop1).isEqualTo(1);
        Assertions.assertThat((String)transform.prop2).isEqualTo("hello");
    }

    @Test
    public void testTransform_withAlias() {
        Table table = new Table("totoTable");
        Column columnA = table.addColumn("a", Integer.TYPE);
        Column columnB = table.addColumn("b", String.class);
        ToBeanRowTransformer testInstance = new ToBeanRowTransformer(Toto.class, (Map)Maps.forHashMap(Column.class, Mutator.class).add((Object)columnA, (Object)Accessors.mutatorByMethodReference(Toto::setProp1)).add((Object)columnB, (Object)Accessors.mutatorByMethodReference(Toto::setProp2)));
        testInstance = testInstance.copyWithAliases(new ColumnedRow(column -> {
            if (column == columnA) {
                return "a_slided";
            }
            if (column == columnB) {
                return "b_slided";
            }
            return null;
        }));
        Row row = new Row();
        row.add("a_slided", (Object)1);
        row.add("b_slided", (Object)"hello");
        Toto transform = (Toto)testInstance.transform(row);
        Assertions.assertThat((int)transform.prop1).isEqualTo(1);
        Assertions.assertThat((String)transform.prop2).isEqualTo("hello");
        testInstance = testInstance.copyWithAliases(new ColumnedRow(column -> {
            if (column == columnA) {
                return "a_slided2";
            }
            if (column == columnB) {
                return "b_slided2";
            }
            return null;
        }));
        row = new Row();
        row.add("a_slided2", (Object)1);
        row.add("b_slided2", (Object)"hello");
        transform = (Toto)testInstance.transform(row);
        Assertions.assertThat((int)transform.prop1).isEqualTo(1);
        Assertions.assertThat((String)transform.prop2).isEqualTo("hello");
    }

    private static class Toto {
        private int prop1;
        private String prop2;

        private Toto() {
        }

        public void setProp1(int prop1) {
            this.prop1 = prop1;
        }

        public void setProp2(String prop2) {
            this.prop2 = prop2;
        }
    }
}

