/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.query;

import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.trace.ModifiableBoolean;
import org.codefilarete.tool.trace.ModifiableLong;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

class PartTreeStalactiteProjection<C, R>
implements RepositoryQuery {
    private final QueryMethod method;
    private final Accumulator<Function<Selectable<Object>, Object>, ?, R> accumulator;
    private final DerivedQuery<C> query;
    private final Consumer<Select> selectConsumer;

    static <T> PartTreeStalactiteProjection<T, Long> forCount(QueryMethod method, EntityPersister<T, ?> entityPersister, PartTree tree) {
        Set columns = ((ConfiguredPersister)entityPersister).getMapping().getIdMapping().getIdentifierAssembler().getColumns();
        final Count count = Operators.count((Iterable)columns);
        if (tree.isDistinct()) {
            count.distinct();
        }
        return new PartTreeStalactiteProjection<T, Long>(method, entityPersister, tree, select -> {
            select.clear();
            select.add((Selectable)count, "row_count");
        }, new Accumulator<Function<Selectable<Long>, Long>, ModifiableLong, Long>(){

            public Supplier<ModifiableLong> supplier() {
                return ModifiableLong::new;
            }

            public BiConsumer<ModifiableLong, Function<Selectable<Long>, Long>> aggregator() {
                return (modifiableLong, selectableObjectFunction) -> {
                    Long countValue = (Long)selectableObjectFunction.apply(count);
                    modifiableLong.reset(countValue.longValue());
                };
            }

            public Function<ModifiableLong, Long> finisher() {
                return ModifiableLong::getValue;
            }
        });
    }

    static <T> PartTreeStalactiteProjection<T, Boolean> forExists(QueryMethod method, EntityPersister<T, ?> entityPersister, PartTree tree) {
        KeepOrderSet pkColumns = ((ConfiguredPersister)entityPersister).getMapping().getTargetTable().getPrimaryKey().getColumns();
        PartTreeStalactiteProjection<T, Boolean> partTreeExists = new PartTreeStalactiteProjection<T, Boolean>(method, entityPersister, tree, arg_0 -> PartTreeStalactiteProjection.lambda$forExists$2((Set)pkColumns, arg_0), new Accumulator<Function<Selectable<Object>, Object>, ModifiableBoolean, Boolean>(){

            public Supplier<ModifiableBoolean> supplier() {
                return () -> new ModifiableBoolean(Boolean.valueOf(false));
            }

            public BiConsumer<ModifiableBoolean, Function<Selectable<Object>, Object>> aggregator() {
                return (modifiableBoolean, selectableObjectFunction) -> modifiableBoolean.setTrue();
            }

            public Function<ModifiableBoolean, Boolean> finisher() {
                return ModifiableBoolean::getValue;
            }
        });
        partTreeExists.getQuery().executableProjectionQuery.limit(1);
        return partTreeExists;
    }

    public <O> PartTreeStalactiteProjection(QueryMethod method, EntityPersister<C, ?> entityPersister, PartTree tree, Consumer<Select> selectConsumer, Accumulator<Function<Selectable<O>, O>, ?, R> accumulator) {
        this.method = method;
        this.accumulator = accumulator;
        Parameters parameters = method.getParameters();
        boolean recreationRequired = parameters.hasDynamicProjection() || parameters.potentiallySortsDynamically();
        try {
            this.selectConsumer = selectConsumer;
            this.query = new DerivedQuery<C>(entityPersister, tree);
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", method, o_O.getMessage()), o_O);
        }
    }

    public DerivedQuery<C> getQuery() {
        return this.query;
    }

    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        Object result = this.query.executableProjectionQuery.execute(this.accumulator);
        if (this.method.getResultProcessor().getReturnedType().isProjecting() || this.method.getParameters().hasDynamicProjection()) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor).processResult(result);
        }
        return (R)result;
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    private static /* synthetic */ void lambda$forExists$2(Set pkColumns, Select selectables) {
        selectables.clear();
        pkColumns.forEach(column -> selectables.add((Selectable)column, column.getAlias()));
    }

    class DerivedQuery<T>
    extends AbstractDerivedQuery<T> {
        protected final EntityPersister.ExecutableProjectionQuery<T, ?> executableProjectionQuery;

        DerivedQuery(EntityPersister<T, ?> entityPersister, PartTree tree) {
            this.executableProjectionQuery = entityPersister.selectProjectionWhere(PartTreeStalactiteProjection.this.selectConsumer);
            tree.forEach(orPart -> orPart.forEach(this::append));
        }

        private void append(Part part) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            Class propertyType = AccessorDefinition.giveDefinition((ValueAccessPoint)((ValueAccessPoint)Iterables.last((List)getter.getAccessors()))).getMemberType();
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), propertyType, part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.executableProjectionQuery.and(this.convertToAccessorChain(part.getProperty()), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

