/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.runtime.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityQueryCriteriaSupport<C, I> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityQueryCriteriaSupport.class);
    private final EntitySelector<C, I> entitySelector;
    private final EntityCriteriaSupport<C> entityCriteriaSupport;
    private final EntityQueryPageSupport<C> queryPageSupport;
    private final PersisterListenerCollection<C, I> persisterListener;

    public EntityQueryCriteriaSupport(EntityCriteriaSupport<C> source, EntitySelector<C, I> entitySelector, PersisterListenerCollection<C, I> persisterListener) {
        this.entitySelector = entitySelector;
        this.entityCriteriaSupport = new EntityCriteriaSupport<C>(source);
        this.queryPageSupport = new EntityQueryPageSupport();
        this.persisterListener = persisterListener;
    }

    private EntityQueryCriteriaSupport(EntitySelector<C, I> entitySelector, EntityCriteriaSupport<C> entityCriteriaSupport, EntityQueryPageSupport<C> queryPageSupport, PersisterListenerCollection<C, I> persisterListener) {
        this.entitySelector = entitySelector;
        this.entityCriteriaSupport = entityCriteriaSupport;
        this.queryPageSupport = queryPageSupport;
        this.persisterListener = persisterListener;
    }

    public EntityQueryCriteriaSupport<C, I> copyFor(EntityQueryPageSupport<C> otherPageSupport) {
        return new EntityQueryCriteriaSupport<C, I>(this.entitySelector, this.entityCriteriaSupport, ((EntityQueryPageSupport)this.queryPageSupport).merge((EntityQueryPageSupport)otherPageSupport), this.persisterListener);
    }

    public EntityCriteriaSupport<C> getEntityCriteriaSupport() {
        return this.entityCriteriaSupport;
    }

    public EntityQueryPageSupport<C> getQueryPageSupport() {
        return this.queryPageSupport;
    }

    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> wrapIntoExecutable() {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        return (RelationalEntityPersister.ExecutableEntityQueryCriteria)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad()).redirect(EntityPersister.OrderByChain.class, this.queryPageSupport, true).redirect(EntityPersister.LimitAware.class, this.queryPageSupport, true).redirect(RelationalEntityCriteria.class, this.entityCriteriaSupport, true).redirect(ConfiguredEntityCriteria::getCriteria, this.entityCriteriaSupport::getCriteria).redirect(ConfiguredEntityCriteria::hasCollectionCriteria, this.entityCriteriaSupport::hasCollectionCriteria).build(ConfiguredExecutableEntityQueryCriteria.class);
    }

    public <R> Function<Accumulator<C, Collection<C>, R>, R> wrapGraphLoad() {
        Hanger.Holder orderByAdapter = new Hanger.Holder();
        Supplier<Set> entityLoader = () -> {
            if (((EntityQueryPageSupport)this.queryPageSupport).getLimit() != null && this.entityCriteriaSupport.getRootConfiguration().hasCollectionProperty()) {
                throw new UnsupportedOperationException("Can't limit query when entity graph contains Collection relations");
            }
            return this.persisterListener.doWithSelectListener(Collections.emptySet(), () -> this.entitySelector.select(this.entityCriteriaSupport, (Consumer)orderByAdapter.get(), limitAware -> Nullable.nullable((Object)((EntityQueryPageSupport)this.queryPageSupport).getLimit()).invoke(limit -> limitAware.limit(limit.getCount().intValue(), limit.getOffset()))));
        };
        return accumulatorParam -> {
            if (this.entityCriteriaSupport.hasCollectionCriteria() && !((EntityQueryPageSupport)this.queryPageSupport).getOrderBy().isEmpty()) {
                orderByAdapter.set(orderByClause -> {});
                LOGGER.debug("Sorting loaded entities in memory");
                Set loadedEntities = (Set)entityLoader.get();
                TreeSet<C> sortedResult = new TreeSet<C>(EntityQueryCriteriaSupport.buildComparator((KeepOrderSet<EntityQueryPageSupport.OrderByItem>)((EntityQueryPageSupport)this.queryPageSupport).getOrderBy()));
                sortedResult.addAll(loadedEntities);
                return accumulatorParam.collect(sortedResult);
            }
            orderByAdapter.set(orderByClause -> {
                KeepOrderSet orderBy = ((EntityQueryPageSupport)this.queryPageSupport).getOrderBy();
                orderBy.forEach(duo -> {
                    Column column = this.entityCriteriaSupport.getRootConfiguration().giveColumn(duo.getProperty());
                    orderByClause.add((Selectable)(duo.isIgnoreCase() ? Operators.lowerCase((Selectable)column) : column), duo.getDirection() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
                });
            });
            return accumulatorParam.collect((Iterable)entityLoader.get());
        };
    }

    @VisibleForTesting
    static <C> Comparator<C> buildComparator(KeepOrderSet<EntityQueryPageSupport.OrderByItem> orderBy) {
        List<Duo> orderByAccessors = orderBy.stream().map(duo -> {
            AccessorChain localResult;
            List<ValueAccessPoint<?>> valueAccessPoints = duo.getProperty();
            if (valueAccessPoints.size() == 1) {
                ValueAccessPoint<?> valueAccessPoint = valueAccessPoints.get(0);
                if (valueAccessPoint instanceof Accessor) {
                    localResult = new AccessorChain(new Accessor[]{(Accessor)valueAccessPoint});
                } else {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
                    localResult = new AccessorChain(new Accessor[]{Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType())});
                }
            } else {
                localResult = new AccessorChain(valueAccessPoints.stream().map(EntityQueryCriteriaSupport::toAccessor).collect(Collectors.toList()));
            }
            localResult.setNullValueHandler(AccessorChain.RETURN_NULL);
            return new Duo((Object)localResult, (Object)duo.getDirection());
        }).collect(Collectors.toList());
        Nullable result = Nullable.nullable((Object)null);
        orderByAccessors.forEach(orderByPawn -> {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> ((AccessorChain)((AccessorChain)orderByPawn.getLeft())).get(arg_0), Comparator.nullsLast(Comparator.naturalOrder()));
            if (orderByPawn.getRight() == EntityPersister.OrderByChain.Order.DESC) {
                comparator = comparator.reversed();
            }
            if (result.isPresent()) {
                Comparator<Object> finalComparator = comparator;
                result.map(c -> c.thenComparing(finalComparator));
            } else {
                result.set(comparator);
            }
        });
        return (Comparator)result.get();
    }

    private static <C, T> Accessor<C, T> toAccessor(ValueAccessPoint<C> valueAccessPoint) {
        if (valueAccessPoint instanceof Accessor) {
            return (Accessor)valueAccessPoint;
        }
        if (valueAccessPoint instanceof ReversibleMutator) {
            return ((ReversibleMutator)valueAccessPoint).toAccessor();
        }
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
        AccessorByMember accessor = Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType());
        return accessor;
    }

    public static class EntityQueryPageSupport<C>
    implements EntityPersister.OrderByChain<C, EntityQueryPageSupport<C>>,
    EntityPersister.LimitAware<EntityQueryPageSupport<C>> {
        private Limit limit;
        private final KeepOrderSet<OrderByItem> orderBy = new KeepOrderSet();

        private Limit getLimit() {
            return this.limit;
        }

        private KeepOrderSet<OrderByItem> getOrderBy() {
            return this.orderBy;
        }

        public EntityQueryPageSupport<C> limit(int count) {
            this.limit = new Limit(Integer.valueOf(count));
            return this;
        }

        public EntityQueryPageSupport<C> limit(int count, Integer offset) {
            this.limit = new Limit(Integer.valueOf(count), offset);
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            AccessorByMethodReference methodReference = new AccessorByMethodReference(getter);
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new AccessorByMethodReference[]{methodReference}), order, false));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            MutatorByMethodReference methodReference = new MutatorByMethodReference(setter);
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new MutatorByMethodReference[]{methodReference}), order, false));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public EntityQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            return this.orderBy(getter, order, false);
        }

        public EntityQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order, boolean ignoreCase) {
            this.orderBy.add((Object)new OrderByItem(getter.getAccessors(), order, ignoreCase));
            getter.getAccessors().forEach(accessor -> this.assertAccessorIsNotIterable((ValueAccessPoint)accessor, AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getMemberType()));
            return this;
        }

        private void assertAccessorIsNotIterable(ValueAccessPoint valueAccessPoint, Class memberType) {
            if (Iterable.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : " + (valueAccessPoint instanceof AbstractReflector ? ((AbstractReflector)valueAccessPoint).getDescription() : AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint)).toString());
            }
        }

        private EntityQueryPageSupport<C> merge(EntityQueryPageSupport<C> other) {
            EntityQueryPageSupport<C> duplicate = new EntityQueryPageSupport<C>();
            if (this.getLimit() != null) {
                duplicate.limit(this.getLimit().getCount(), this.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(this.orderBy);
            if (super.getLimit() != null) {
                duplicate.limit(super.getLimit().getCount(), super.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(other.orderBy);
            return duplicate;
        }

        public static class OrderByItem {
            private final List<? extends ValueAccessPoint<?>> property;
            private final EntityPersister.OrderByChain.Order direction;
            private final boolean ignoreCase;

            public OrderByItem(List<? extends ValueAccessPoint<?>> property, EntityPersister.OrderByChain.Order direction, boolean ignoreCase) {
                this.property = property;
                this.direction = direction;
                this.ignoreCase = ignoreCase;
            }

            public List<? extends ValueAccessPoint<?>> getProperty() {
                return this.property;
            }

            public EntityPersister.OrderByChain.Order getDirection() {
                return this.direction;
            }

            public boolean isIgnoreCase() {
                return this.ignoreCase;
            }
        }
    }

    private static interface ConfiguredExecutableEntityQueryCriteria<C>
    extends ConfiguredEntityCriteria,
    RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ConfiguredExecutableEntityQueryCriteria<C>> {
    }
}

