/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;

public class ColumnedRow {
    private final Function<Selectable<?>, String> aliasProvider;

    public ColumnedRow() {
        this(Selectable::getExpression);
    }

    public ColumnedRow(Function<? extends Selectable<?>, String> aliasProvider) {
        this.aliasProvider = aliasProvider;
    }

    @Nullable
    public <T extends Table<T>, O> O getValue(Selectable<O> column, Row row) {
        String columnAlias = this.getAlias(column);
        if (columnAlias != null) {
            return (O)row.get(columnAlias);
        }
        throw new IllegalArgumentException("Column " + column + " has no matching alias in result set");
    }

    public String getAlias(Selectable<?> column) {
        return this.aliasProvider.apply(column);
    }
}

