/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityIsManagedByPersisterAsserter;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class EntityIsManagedByPersisterAsserterTest {
    EntityIsManagedByPersisterAsserterTest() {
    }

    public static Object[][] assertMethodIsInvoked() throws NoSuchMethodException {
        Class<EntityPersister> persisterInterface = EntityPersister.class;
        return new Object[][]{{persisterInterface.getMethod("persist", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("persist", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}, {persisterInterface.getMethod("insert", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("insert", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}, {persisterInterface.getMethod("update", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("update", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}, {persisterInterface.getMethod("update", Iterable.class, Boolean.TYPE), new Object[]{Arrays.asList((Object[])new Duo[]{new Duo((Object)new Vehicle(42L), (Object)new Vehicle(42L))}), true}}, {persisterInterface.getMethod("update", Object.class, Object.class, Boolean.TYPE), new Object[]{new Vehicle(42L), new Vehicle(42L), true}}, {persisterInterface.getMethod("updateById", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("updateById", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}, {persisterInterface.getMethod("delete", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("delete", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}, {persisterInterface.getMethod("deleteById", Object.class), new Object[]{new Vehicle(42L)}}, {persisterInterface.getMethod("deleteById", Iterable.class), new Object[]{Arrays.asList((Object[])new Vehicle[]{new Vehicle(42L)})}}};
    }

    @ParameterizedTest
    @MethodSource
    void assertMethodIsInvoked(Method invokedMethod, Object[] args) throws InvocationTargetException, IllegalAccessException {
        ConfiguredRelationalPersister surrogateMock = (ConfiguredRelationalPersister)Mockito.mock(ConfiguredRelationalPersister.class);
        Mockito.when((Object)surrogateMock.getClassToPersist()).thenReturn(Vehicle.class);
        Mockito.when((Object)surrogateMock.getId(args[0])).thenReturn((Object)42L);
        EntityMapping mappingStrategyMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)mappingStrategyMock.getId(ArgumentMatchers.any())).thenReturn((Object)42L);
        Mockito.when((Object)surrogateMock.getMapping()).thenReturn((Object)mappingStrategyMock);
        EntityIsManagedByPersisterAsserter testInstance = (EntityIsManagedByPersisterAsserter)Mockito.spy((Object)new EntityIsManagedByPersisterAsserter(surrogateMock));
        invokedMethod.invoke((Object)testInstance, args);
        if (args[0] instanceof Iterable) {
            ((EntityIsManagedByPersisterAsserter)Mockito.verify((Object)testInstance, (VerificationMode)Mockito.times((int)1))).assertPersisterManagesEntities((Iterable)ArgumentMatchers.any());
        } else {
            ((EntityIsManagedByPersisterAsserter)Mockito.verify((Object)testInstance, (VerificationMode)Mockito.times((int)1))).assertPersisterManagesEntity(ArgumentMatchers.any());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"assertMethodIsInvoked"})
    void assertMethodIsInvoked_withPolymorphicPersisterAtInit(Method invokedMethod, Object[] args) throws InvocationTargetException, IllegalAccessException {
        ConfiguredRelationalPersister surrogateMock = (ConfiguredRelationalPersister)Mockito.mock(ConfiguredRelationalPersister.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{PolymorphicPersister.class}));
        Mockito.when((Object)((PolymorphicPersister)surrogateMock).getSupportedEntityTypes()).thenReturn((Object)Arrays.asSet((Object[])new Class[]{Vehicle.class}));
        Mockito.when((Object)surrogateMock.getId(args[0])).thenReturn((Object)42L);
        EntityMapping mappingStrategyMock = (EntityMapping)Mockito.mock(EntityMapping.class);
        Mockito.when((Object)mappingStrategyMock.getId(ArgumentMatchers.any())).thenReturn((Object)42L);
        Mockito.when((Object)surrogateMock.getMapping()).thenReturn((Object)mappingStrategyMock);
        EntityIsManagedByPersisterAsserter testInstance = (EntityIsManagedByPersisterAsserter)Mockito.spy((Object)new EntityIsManagedByPersisterAsserter(surrogateMock));
        invokedMethod.invoke((Object)testInstance, args);
        if (args[0] instanceof Iterable) {
            ((EntityIsManagedByPersisterAsserter)Mockito.verify((Object)testInstance, (VerificationMode)Mockito.times((int)1))).assertPersisterManagesEntities((Iterable)ArgumentMatchers.any());
        } else {
            ((EntityIsManagedByPersisterAsserter)Mockito.verify((Object)testInstance, (VerificationMode)Mockito.times((int)1))).assertPersisterManagesEntity(ArgumentMatchers.any());
        }
    }
}

