/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.key.CompositeKeyMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.compositekey.House;
import org.codefilarete.stalactite.engine.model.compositekey.Person;
import org.codefilarete.stalactite.engine.model.compositekey.Pet;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FluentEntityMappingConfigurationSupportCompositeKeyTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final Set<Person.PersonId> persistedPersons = new HashSet<Person.PersonId>();
    private final Set<Pet.PetId> persistedPets = new HashSet<Pet.PetId>();
    private final Set<House.HouseId> persistedHouses = new HashSet<House.HouseId>();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() throws SQLException {
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
        this.clearPersistedStatuses();
    }

    public void clearPersistedStatuses() {
        this.persistedPersons.clear();
        this.persistedPets.clear();
        this.persistedHouses.clear();
    }

    @Test
    void crud() {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::setId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        dummyPerson.setAge(36);
        personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
        Table personTable = new Table("Person");
        Column age = personTable.addColumn("age", Integer.TYPE);
        List ages = this.persistenceContext.select(SerializableFunction.identity(), age);
        Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
        personPersister.delete((Object)dummyPerson);
        ages = this.persistenceContext.select(SerializableFunction.identity(), age);
        Assertions.assertThat((List)ages).isEmpty();
    }

    @Test
    void crud_columnNameOverridden_columnNameIsUsed() {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).columnName("familyName").map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        Assertions.assertThat((String)loadedPerson.getId().getLastName()).isEqualTo("Do");
    }

    @Test
    void crud_fieldNameOverridden_fieldNameIsUsed() throws SQLException {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getFamilyName).fieldName("lastName").map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        Assertions.assertThat((String)loadedPerson.getId().getLastName()).isEqualTo("Do");
        ResultSet tableColumns = this.persistenceContext.getConnectionProvider().giveConnection().getMetaData().getColumns(null, null, ((ConfiguredPersister)this.persistenceContext.findPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase(), null);
        ResultSetIterator<String> columnNameReader = new ResultSetIterator<String>(tableColumns){

            public String convert(ResultSet resultSet) throws SQLException {
                return resultSet.getString("COLUMN_NAME");
            }
        };
        Assertions.assertThat((List)columnNameReader.convert()).containsExactlyInAnyOrder((Object[])new String[]{"AGE", "FIRSTNAME", "LASTNAME", "ADDRESS"});
    }

    @Test
    void crud_fieldNameOverriddenAndColumnNameOverridden_columnNameIsUsed() throws SQLException {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getFamilyName).fieldName("lastName").columnName("familyName").map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        Assertions.assertThat((String)loadedPerson.getId().getLastName()).isEqualTo("Do");
        ResultSet tableColumns = this.persistenceContext.getConnectionProvider().giveConnection().getMetaData().getColumns(null, null, ((ConfiguredPersister)this.persistenceContext.findPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase(), null);
        ResultSetIterator<String> columnNameReader = new ResultSetIterator<String>(tableColumns){

            public String convert(ResultSet resultSet) throws SQLException {
                return resultSet.getString("COLUMN_NAME");
            }
        };
        Assertions.assertThat((List)columnNameReader.convert()).containsExactlyInAnyOrder((Object[])new String[]{"AGE", "FIRSTNAME", "FAMILYNAME", "ADDRESS"});
    }

    @Test
    void crud_oneToMany_ownedByTarget() {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> this.persistedPets.add(p.getId()), p -> this.persistedPets.contains(p.getId()))).mappedBy(Pet::getOwner).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
        dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
        Set personIds = (Set)Iterables.collect(loadedPerson.getPets(), pet -> pet.getOwner().getId(), HashSet::new);
        Assertions.assertThat((Collection)personIds).containsExactly((Object[])new Person.PersonId[]{dummyPerson.getId()});
        dummyPerson.setAge(36);
        personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
        Table personTable = new Table("Person");
        Column age = personTable.addColumn("age", Integer.TYPE);
        List ages = this.persistenceContext.select(SerializableFunction.identity(), age);
        Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
        personPersister.delete((Object)dummyPerson);
        Column firstNameColumn = personTable.addColumn("firstName", String.class);
        Column lastNameColumn = personTable.addColumn("lastName", String.class);
        Column addressColumn = personTable.addColumn("address", String.class);
        List persons = this.persistenceContext.select(Person.PersonId::new, firstNameColumn, lastNameColumn, addressColumn);
        Assertions.assertThat((List)persons).isEmpty();
    }

    @Test
    void crud_oneToMany_withAssociationTable() {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> this.persistedPets.add(p.getId()), p -> this.persistedPets.contains(p.getId()))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
        dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
        dummyPerson.setAge(36);
        personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
        Table personTable = new Table("Person");
        Column age = personTable.addColumn("age", Integer.TYPE);
        List ages = this.persistenceContext.select(SerializableFunction.identity(), age);
        Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
        personPersister.delete((Object)dummyPerson);
        Column firstNameColumn = personTable.addColumn("firstName", String.class);
        Column lastNameColumn = personTable.addColumn("lastName", String.class);
        Column addressColumn = personTable.addColumn("address", String.class);
        List persons = this.persistenceContext.select(Person.PersonId::new, firstNameColumn, lastNameColumn, addressColumn);
        Assertions.assertThat((List)persons).isEmpty();
    }

    @Test
    void crud_manyToMany() {
        EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> this.persistedPersons.add(p.getId()), p -> this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> this.persistedPets.add(p.getId()), p -> this.persistedPets.contains(p.getId()))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
        dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
        dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
        dummyPerson.setAge(35);
        personPersister.insert((Object)dummyPerson);
        Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
        ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[0])).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
        dummyPerson.setAge(36);
        personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
        Table personTable = new Table("Person");
        Column age = personTable.addColumn("age", Integer.TYPE);
        List ages = this.persistenceContext.select(SerializableFunction.identity(), age);
        Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
        personPersister.delete((Object)dummyPerson);
        Column firstNameColumn = personTable.addColumn("firstName", String.class);
        Column lastNameColumn = personTable.addColumn("lastName", String.class);
        Column addressColumn = personTable.addColumn("address", String.class);
        List persons = this.persistenceContext.select(Person.PersonId::new, firstNameColumn, lastNameColumn, addressColumn);
        Assertions.assertThat((List)persons).isEmpty();
    }

    static Object[][] persist_polymorphic_data() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        HashSet persistedPet = new HashSet();
        Object[][] objectArray = new Object[3][];
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "single table";
        objectArray2[1] = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), persistedPet::add, persistedPet::contains).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed), (Object)"Pet").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed), (Object)"Dog")).build(persistenceContext1);
        objectArray[0] = objectArray2;
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = "joined tables";
        objectArray3[1] = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), persistedPet::add, persistedPet::contains).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed))).build(persistenceContext2);
        objectArray[1] = objectArray3;
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = "table per class";
        objectArray4[1] = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), persistedPet::add, persistedPet::contains).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed))).build(persistenceContext3);
        objectArray[2] = objectArray4;
        Object[][] result = objectArray;
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest
    @MethodSource(value={"persist_polymorphic_data"})
    void persist_polymorphic(String testDisplayName, EntityPersister<Pet, Pet.PetId> petPersister) {
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Pet.Cat cat = new Pet.Cat(new Pet.PetId("Pluto", "Dog", 4));
        cat.setCatBreed(Pet.CatBreed.Persian);
        petPersister.persist((Object)cat);
        Pet loadedPet = (Pet)petPersister.select((Object)cat.getId());
        Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
        cat.setCatBreed(Pet.CatBreed.Persian);
        petPersister.persist((Object)cat);
        loadedPet = (Pet)petPersister.select((Object)cat.getId());
        Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
    }

    private static class MemoryAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> events = new ArrayList<LoggingEvent>();

        private MemoryAppender() {
        }

        public List<LoggingEvent> getEvents() {
            return this.events;
        }

        protected void append(LoggingEvent event) {
            this.events.add(event);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    @Nested
    class CRUD_Polymorphism {
        CRUD_Polymorphism() {
        }

        @Test
        void joinedTables() throws SQLException {
            EntityPersister petPersister = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Pet.Cat cat = new Pet.Cat(new Pet.PetId("Pluto", "Dog", 4));
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.insert((Object)cat);
            Pet loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.update((Object)cat, (Object)loadedPet, true);
            loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().commit();
            petPersister.delete((Object)cat);
            String petName = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select name from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)petName).isNull();
            String catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Cat", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().rollback();
            petPersister.deleteById((Object)cat);
            petName = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select name from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)petName).isNull();
            catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Cat", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
        }

        @Test
        void singleTable() throws SQLException {
            EntityPersister petPersister = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed), (Object)"Pet").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed), (Object)"Dog")).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Pet.Cat cat = new Pet.Cat(new Pet.PetId("Pluto", "Dog", 4));
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.insert((Object)cat);
            Pet loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.update((Object)cat, (Object)loadedPet, true);
            loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().commit();
            petPersister.delete((Object)cat);
            String petName = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select name from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)petName).isNull();
            String catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().rollback();
            petPersister.deleteById((Object)cat);
            petName = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select name from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)petName).isNull();
            catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Pet", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
        }

        @Test
        void tablePerClass() throws SQLException {
            EntityPersister petPersister = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass(Pet.class).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class).mapEnum(Pet.Cat::getCatBreed)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Dog.class).mapEnum(Pet.Dog::getDogBreed))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Pet.Cat cat = new Pet.Cat(new Pet.PetId("Pluto", "Dog", 4));
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.insert((Object)cat);
            Pet loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            cat.setCatBreed(Pet.CatBreed.Persian);
            petPersister.update((Object)cat, (Object)loadedPet, true);
            loadedPet = (Pet)petPersister.select((Object)cat.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)cat);
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().commit();
            petPersister.delete((Object)cat);
            String catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Cat", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection().rollback();
            petPersister.deleteById((Object)cat);
            catBreed = (String)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.newQuery((CharSequence)"select catBreed from Cat", String.class).mapKey("name", String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)catBreed).isNull();
        }
    }

    @Nested
    class Persist {
        Persist() {
        }

        @Test
        void oneToMany() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId()))).mappedBy(Pet::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
            dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
            dummyPerson.setAge(35);
            personPersister.persist((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
            Set personIds = (Set)Iterables.collect(loadedPerson.getPets(), pet -> pet.getOwner().getId(), HashSet::new);
            Assertions.assertThat((Collection)personIds).containsExactly((Object[])new Person.PersonId[]{dummyPerson.getId()});
            loadedPerson.setAge(36);
            loadedPerson.addPet(new Pet(new Pet.PetId("Schrodinger", "Cat", -42)));
            loadedPerson.removePet(new Pet.PetId("Rantanplan", "Dog", 5));
            personPersister.persist((Object)loadedPerson);
            loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((int)loadedPerson.getAge()).isEqualTo(36);
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrder((Object[])new Pet[]{new Pet(new Pet.PetId("Pluto", "Dog", 4)), new Pet(new Pet.PetId("Schrodinger", "Cat", -42))});
        }

        @Test
        void oneToMany_noPersistedStateManagingLambdas_persistIsBasedOnDatabaseSelect() {
            FluentEntityMappingConfigurationSupportCompositeKeyTest.this.dialect.getDmlGenerator().sortColumnsAlphabetically();
            Logger logger = LogManager.getLogger(SQLOperation.class);
            Level currentLevel = logger.getLevel();
            logger.setLevel(Level.DEBUG);
            MemoryAppender memoryAppender = new MemoryAppender();
            logger.addAppender((Appender)memoryAppender);
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress)).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge))).mappedBy(Pet::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
            dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
            dummyPerson.setAge(35);
            personPersister.persist((Object)dummyPerson);
            Assertions.assertThat(memoryAppender.getEvents()).extracting(LoggingEvent::getMessage).containsExactlyElementsOf((Iterable)Arrays.asList((Object[])new String[]{"select Person.age as Person_age, Person.firstName as Person_firstName, Person.lastName as Person_lastName, Person.address as Person_address, Pet.name as Pet_name, Pet.race as Pet_race, Pet.age as Pet_age from Person left outer join Pet as Pet on Person.firstName = Pet.ownerFirstName and Person.lastName = Pet.ownerLastName and Person.address = Pet.ownerAddress where (Person.firstName, Person.lastName, Person.address) in ((?, ?, ?))", "Batching statement 1 times", "insert into Person(address, age, firstName, lastName) values (?, ?, ?, ?)", "select Pet.name as Pet_name, Pet.race as Pet_race, Pet.age as Pet_age from Pet where (Pet.name, Pet.race, Pet.age) in ((?, ?, ?), (?, ?, ?))", "Batching statement 2 times", "insert into Pet(age, name, ownerAddress, ownerFirstName, ownerLastName, race) values (?, ?, ?, ?, ?, ?)"}));
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
            Set personIds = (Set)Iterables.collect(loadedPerson.getPets(), pet -> pet.getOwner().getId(), HashSet::new);
            Assertions.assertThat((Collection)personIds).containsExactly((Object[])new Person.PersonId[]{dummyPerson.getId()});
            loadedPerson.setAge(36);
            loadedPerson.addPet(new Pet(new Pet.PetId("Schrodinger", "Cat", -42)));
            loadedPerson.removePet(new Pet.PetId("Rantanplan", "Dog", 5));
            memoryAppender.getEvents().clear();
            personPersister.persist((Object)loadedPerson);
            Assertions.assertThat(memoryAppender.getEvents()).extracting(LoggingEvent::getMessage).containsExactlyElementsOf((Iterable)Arrays.asList((Object[])new String[]{"select Person.age as Person_age, Person.firstName as Person_firstName, Person.lastName as Person_lastName, Person.address as Person_address, Pet.name as Pet_name, Pet.race as Pet_race, Pet.age as Pet_age from Person left outer join Pet as Pet on Person.firstName = Pet.ownerFirstName and Person.lastName = Pet.ownerLastName and Person.address = Pet.ownerAddress where (Person.firstName, Person.lastName, Person.address) in ((?, ?, ?))", "Batching statement 1 times", "update Person set age = ? where firstName = ? and lastName = ? and address = ?", "Batching statement 1 times", "update Pet set ownerAddress = ?, ownerFirstName = ?, ownerLastName = ? where name = ? and race = ? and age = ?", "Batching statement 1 times", "update Pet set ownerAddress = ?, ownerFirstName = ?, ownerLastName = ? where name = ? and race = ? and age = ?", "select Pet.name as Pet_name, Pet.race as Pet_race, Pet.age as Pet_age from Pet where (Pet.name, Pet.race, Pet.age) in ((?, ?, ?))", "Batching statement 1 times", "insert into Pet(age, name, ownerAddress, ownerFirstName, ownerLastName, race) values (?, ?, ?, ?, ?, ?)"}));
            logger.setLevel(currentLevel);
        }

        @Test
        void manyToMany() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapManyToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId()))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.addPet(new Pet(new Pet.PetId("Pluto", "Dog", 4)));
            dummyPerson.addPet(new Pet(new Pet.PetId("Rantanplan", "Dog", 5)));
            dummyPerson.setAge(35);
            personPersister.persist((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
            loadedPerson.setAge(36);
            loadedPerson.addPet(new Pet(new Pet.PetId("Schrodinger", "Cat", -42)));
            loadedPerson.removePet(new Pet.PetId("Rantanplan", "Dog", 5));
            personPersister.persist((Object)loadedPerson);
            loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((int)loadedPerson.getAge()).isEqualTo(36);
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrder((Object[])new Pet[]{new Pet(new Pet.PetId("Pluto", "Dog", 4)), new Pet(new Pet.PetId("Schrodinger", "Cat", -42))});
        }

        @Test
        void oneToMany_manyTypeIsCompositeKeyAndPolymorphic() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class, Pet.PetId.class)))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.getPets().add(new Pet.Cat(new Pet.PetId("Fluffy", "Cat", 3)));
            dummyPerson.getPets().add(new Pet.Cat(new Pet.PetId("Whiskers", "Cat", 2)));
            personPersister.persist((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
            loadedPerson.setAge(36);
            loadedPerson.addPet(new Pet.Cat(new Pet.PetId("Schrodinger", "Cat", -42)));
            loadedPerson.removePet(new Pet.PetId("Whiskers", "Cat", 2));
            personPersister.persist((Object)loadedPerson);
            loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((int)loadedPerson.getAge()).isEqualTo(36);
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrder((Object[])new Pet[]{new Pet.Cat(new Pet.PetId("Fluffy", "Cat", 3)), new Pet.Cat(new Pet.PetId("Schrodinger", "Cat", -42))});
        }

        @Test
        <T extends Table<T>> void oneToMany_manyTypeIsCompositeKeyAndPolymorphic_realLife() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Pet.Cat.class, Pet.PetId.class)))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.getPets().add(new Pet.Cat(new Pet.PetId("Fluffy", "Cat", 3)));
            dummyPerson.getPets().add(new Pet.Cat(new Pet.PetId("Whiskers", "Cat", 2)));
            personPersister.persist((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrderElementsOf(dummyPerson.getPets());
            loadedPerson.setAge(36);
            loadedPerson.addPet(new Pet.Cat(new Pet.PetId("Schrodinger", "Cat", -42)));
            loadedPerson.removePet(new Pet.PetId("Whiskers", "Cat", 2));
            personPersister.persist((Object)loadedPerson);
            loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((int)loadedPerson.getAge()).isEqualTo(36);
            ((AbstractCollectionAssert)Assertions.assertThat(loadedPerson.getPets()).usingRecursiveFieldByFieldElementComparatorIgnoringFields(new String[]{"owner"})).containsExactlyInAnyOrder((Object[])new Pet[]{new Pet.Cat(new Pet.PetId("Fluffy", "Cat", 3)), new Pet.Cat(new Pet.PetId("Schrodinger", "Cat", -42))});
        }
    }

    @Nested
    class WithEnum {
        WithEnum() {
        }

        @Test
        void byOrdinal() {
            EntityPersister petPersister = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).mapEnum(Pet.PetId::getType).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Pet dummyPet = new Pet(new Pet.PetId("Pluto", Pet.PetType.Dog, 4));
            petPersister.persist((Object)dummyPet);
            Pet loadedPet = (Pet)petPersister.select((Object)dummyPet.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)dummyPet);
        }

        @Test
        void byName() {
            EntityPersister petPersister = MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).mapEnum(Pet.PetId::getType).byName().map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId())).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Pet dummyPet = new Pet(new Pet.PetId("Pluto", Pet.PetType.Dog, 4));
            petPersister.persist((Object)dummyPet);
            Pet loadedPet = (Pet)petPersister.select((Object)dummyPet.getId());
            Assertions.assertThat((Object)loadedPet).usingRecursiveComparison().isEqualTo((Object)dummyPet);
        }
    }

    @Nested
    class CRUDOneToOne {
        CRUDOneToOne() {
        }

        @Test
        void compositeToSingleKey_ownedBySource() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Long.class).mapKey(House::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement())).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.setHouse(new House());
            dummyPerson.setAge(35);
            personPersister.insert((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((Long)loadedPerson.getHouse().getId()).isEqualTo(1L);
            dummyPerson.setAge(36);
            personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
            Table personTable = new Table("Person");
            Column age = personTable.addColumn("age", Integer.TYPE);
            List ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
            personPersister.delete((Object)dummyPerson);
            ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).isEmpty();
        }

        @Test
        void compositeToSingleKey_ownedByTarget() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Long.class).mapKey(House::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement())).mappedBy(House::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.setHouse(new House());
            dummyPerson.setAge(35);
            personPersister.insert((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((Long)loadedPerson.getHouse().getId()).isEqualTo(1L);
            dummyPerson.setAge(36);
            personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
            Table personTable = new Table("Person");
            Column age = personTable.addColumn("age", Integer.TYPE);
            List ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
            personPersister.delete((Object)dummyPerson);
            ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).isEmpty();
        }

        @Test
        void compositeToCompositeKey_ownedBySource() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, House.HouseId.class).mapCompositeKey(House::getHouseId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(House.HouseId.class).map(House.HouseId::getNumber).map(House.HouseId::getStreet).map(House.HouseId::getZipCode).map(House.HouseId::getCity), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.add(h.getHouseId()), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.contains(h.getHouseId()))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.setHouse(new House(new House.HouseId(42, "Stalactite street", "888", "CodeFilarete City")));
            dummyPerson.setAge(35);
            personPersister.insert((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((Object)loadedPerson.getHouse().getHouseId()).usingRecursiveComparison().isEqualTo((Object)new House.HouseId(42, "Stalactite street", "888", "CodeFilarete City"));
            dummyPerson.setAge(36);
            personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
            Table personTable = new Table("Person");
            Column age = personTable.addColumn("age", Integer.TYPE);
            List ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
            personPersister.delete((Object)dummyPerson);
            ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).isEmpty();
        }

        @Test
        void compositeToCompositeKey_ownedByTarget() {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, House.HouseId.class).mapCompositeKey(House::getHouseId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(House.HouseId.class).map(House.HouseId::getNumber).map(House.HouseId::getStreet).map(House.HouseId::getZipCode).map(House.HouseId::getCity), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.add(h.getHouseId()), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.contains(h.getHouseId()))).mappedBy(House::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person dummyPerson = new Person(new Person.PersonId("John", "Do", "nowhere"));
            dummyPerson.setHouse(new House(new House.HouseId(42, "Stalactite street", "888", "CodeFilarete City")));
            dummyPerson.setAge(35);
            personPersister.insert((Object)dummyPerson);
            Person loadedPerson = (Person)personPersister.select((Object)dummyPerson.getId());
            Assertions.assertThat((Object)loadedPerson.getHouse().getHouseId()).usingRecursiveComparison().isEqualTo((Object)new House.HouseId(42, "Stalactite street", "888", "CodeFilarete City"));
            dummyPerson.setAge(36);
            personPersister.update((Object)dummyPerson, (Object)loadedPerson, true);
            Table personTable = new Table("Person");
            Column age = personTable.addColumn("age", Integer.TYPE);
            List ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).containsExactly((Object[])new Integer[]{36});
            personPersister.delete((Object)dummyPerson);
            ages = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.select(SerializableFunction.identity(), age);
            Assertions.assertThat((List)ages).isEmpty();
        }
    }

    @Nested
    class ForeignKeyCreation {
        ForeignKeyCreation() {
        }

        @Test
        void oneToOne_compositeToSingleKey_relationOwnedBySource() throws SQLException {
            MappingEase.entityBuilder(Person.class, Person.PersonId.class).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Long.class).mapKey(House::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement())).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSet exportedKeysForPersonTable = currentConnection.getMetaData().getExportedKeys(null, null, "HOUSE");
            Map<String, JdbcForeignKey> foreignKeyPerName = this.giveForeignKeys(exportedKeysForPersonTable);
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_PERSON_HOUSEID_HOUSE_ID", "PERSON", "HOUSEID", "HOUSE", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void oneToOne_compositeToSingleKey_relationOwnedByTarget() throws SQLException {
            MappingEase.entityBuilder(Person.class, Person.PersonId.class).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, Long.class).mapKey(House::getId, (IdentifierPolicy)IdentifierPolicy.databaseAutoIncrement())).mappedBy(House::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSet exportedKeysForPersonTable = currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.findPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase());
            Map<String, JdbcForeignKey> foreignKeyPerName = this.giveForeignKeys(exportedKeysForPersonTable);
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_A240422", "HOUSE", "OWNERFIRSTNAME, OWNERLASTNAME, OWNERADDRESS", "PERSON", "FIRSTNAME, LASTNAME, ADDRESS");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void oneToOne_compositeToCompositeKey_relationOwnedBySource() throws SQLException {
            MappingEase.entityBuilder(Person.class, Person.PersonId.class).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, House.HouseId.class).mapCompositeKey(House::getHouseId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(House.HouseId.class).map(House.HouseId::getNumber).map(House.HouseId::getStreet).map(House.HouseId::getZipCode).map(House.HouseId::getCity), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.add(h.getHouseId()), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.contains(h.getHouseId()))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSet exportedKeysForPersonTable = currentConnection.getMetaData().getExportedKeys(null, null, "HOUSE");
            Map<String, JdbcForeignKey> foreignKeyPerName = this.giveForeignKeys(exportedKeysForPersonTable);
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_8B87D9BD", "PERSON", "HOUSENUMBER, HOUSESTREET, HOUSEZIPCODE, HOUSECITY", "HOUSE", "NUMBER, STREET, ZIPCODE, CITY");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void oneToOne_compositeToCompositeKey_relationOwnedByTarget() throws SQLException {
            MappingEase.entityBuilder(Person.class, Person.PersonId.class).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).mapOneToOne(Person::getHouse, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(House.class, House.HouseId.class).mapCompositeKey(House::getHouseId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(House.HouseId.class).map(House.HouseId::getNumber).map(House.HouseId::getStreet).map(House.HouseId::getZipCode).map(House.HouseId::getCity), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.add(h.getHouseId()), h -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedHouses.contains(h.getHouseId()))).mappedBy(House::getOwner).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSet exportedKeysForPersonTable = currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.findPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase());
            Map<String, JdbcForeignKey> foreignKeyPerName = this.giveForeignKeys(exportedKeysForPersonTable);
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_A240422", "HOUSE", "OWNERFIRSTNAME, OWNERLASTNAME, OWNERADDRESS", "PERSON", "FIRSTNAME, LASTNAME, ADDRESS");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void oneToMany_compositeToCompositeKey_withAssociationTable() throws SQLException {
            EntityPersister personPersister = MappingEase.entityBuilder(Person.class, Person.PersonId.class).mapCompositeKey(Person::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Person.PersonId.class).map(Person.PersonId::getFirstName).map(Person.PersonId::getLastName).map(Person.PersonId::getAddress), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPersons.contains(p.getId())).map(Person::getAge).mapOneToMany(Person::getPets, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Pet.class, Pet.PetId.class).mapCompositeKey(Pet::getId, (CompositeKeyMappingConfigurationProvider)MappingEase.compositeKeyBuilder(Pet.PetId.class).map(Pet.PetId::getName).map(Pet.PetId::getRace).map(Pet.PetId::getAge), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.add(p.getId()), p -> FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistedPets.contains(p.getId()))).build(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSet exportedKeysForPersonTable = currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)FluentEntityMappingConfigurationSupportCompositeKeyTest.this.persistenceContext.findPersister(Person.class)).getMapping().getTargetTable().getName().toUpperCase());
            Map<String, JdbcForeignKey> foreignKeyPerName = this.giveForeignKeys(exportedKeysForPersonTable);
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_47CDB94D", "PERSON_PETS", "PERSON_FIRSTNAME, PERSON_LASTNAME, PERSON_ADDRESS", "PERSON", "FIRSTNAME, LASTNAME, ADDRESS");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
            ResultSet exportedKeysForPetTable = currentConnection.getMetaData().getExportedKeys(null, null, "PET");
            foreignKeyPerName = this.giveForeignKeys(exportedKeysForPetTable);
            foundForeignKey = (JdbcForeignKey)Iterables.first(foreignKeyPerName).getValue();
            expectedForeignKey = new JdbcForeignKey("FK_3124176C", "PERSON_PETS", "PETS_NAME, PETS_RACE, PETS_AGE", "PET", "NAME, RACE, AGE");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        private Map<String, JdbcForeignKey> giveForeignKeys(ResultSet exportedKeysForPersonTable) {
            HashMap<String, JdbcForeignKey> result = new HashMap<String, JdbcForeignKey>();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(exportedKeysForPersonTable){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    String fkName = rs.getString("FK_NAME");
                    String fktableName = rs.getString("FKTABLE_NAME");
                    String fkcolumnName = rs.getString("FKCOLUMN_NAME");
                    String pktableName = rs.getString("PKTABLE_NAME");
                    String pkcolumnName = rs.getString("PKCOLUMN_NAME");
                    return new JdbcForeignKey(fkName, fktableName, fkcolumnName, pktableName, pkcolumnName);
                }
            };
            fkPersonIterator.forEachRemaining(jdbcForeignKey -> {
                String fkName = jdbcForeignKey.getName();
                String fktableName = jdbcForeignKey.getSrcTableName();
                String fkcolumnName = jdbcForeignKey.getSrcColumnName();
                String pktableName = jdbcForeignKey.getTargetTableName();
                String pkcolumnName = jdbcForeignKey.getTargetColumnName();
                result.compute(fkName, (k, fk) -> fk == null ? new JdbcForeignKey(fkName, fktableName, fkcolumnName, pktableName, pkcolumnName) : new JdbcForeignKey(fkName, fktableName, fk.getSrcColumnName() + ", " + fkcolumnName, pktableName, fk.getTargetColumnName() + ", " + pkcolumnName));
            });
            return result;
        }
    }
}

