/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class Update {
    private final Table targetTable;
    private final Set<UpdateColumn> columns = new LinkedHashSet<UpdateColumn>();
    private final Criteria<?> criteriaSurrogate = new Criteria();

    public Update(Table targetTable) {
        this.targetTable = targetTable;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public Criteria getCriteria() {
        return this.criteriaSurrogate;
    }

    public Update set(Column<Table, ?> column) {
        this.columns.add(new UpdateColumn(column));
        return this;
    }

    public <C> Update set(Column<Table, C> column, C value) {
        this.columns.add(new UpdateColumn(column, value));
        return this;
    }

    public <C> Update set(Column<Table, C> column1, Column<Table, C> column2) {
        this.columns.add(new UpdateColumn(column1, column2));
        return this;
    }

    public Set<UpdateColumn> getColumns() {
        return this.columns;
    }

    public CriteriaChain where(Column column, String condition) {
        return this.criteriaSurrogate.and(column, condition);
    }

    public CriteriaChain where(Column column, ConditionalOperator condition) {
        return this.criteriaSurrogate.and(column, condition);
    }

    public static class UpdateColumn {
        public static final Object PLACEHOLDER = new Object();
        private final Column<Table, Object> column;
        private final Object value;

        public UpdateColumn(Column<Table, ?> column) {
            this(column, PLACEHOLDER);
        }

        public <C> UpdateColumn(Column<Table, C> column, C value) {
            this.column = column;
            this.value = value;
        }

        public Column<Table, Object> getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

