/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Iterator;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PreparedSQLWrapper;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringAppenderWrapper;
import org.codefilarete.stalactite.query.builder.UnionSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.PairIterator;

public class FromSQLBuilderFactory {
    public FromSQLBuilder fromBuilder(From from, DMLNameProvider dmlNameProvider, QuerySQLBuilderFactory querySQLBuilderFactory) {
        return new FromSQLBuilder(from, dmlNameProvider, querySQLBuilderFactory);
    }

    public static class FromSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final From from;
        private final DMLNameProvider dmlNameProvider;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;

        public FromSQLBuilder(From from, DMLNameProvider dmlNameProvider, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.from = from;
            this.dmlNameProvider = dmlNameProvider;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
        }

        @Override
        public String toSQL() {
            if (this.from.getRoot() == null) {
                throw new IllegalArgumentException("Empty from");
            }
            StringAppender result = new StringAppender();
            FromGenerator fromGenerator = new FromGenerator(new StringAppenderWrapper(result, this.dmlNameProvider), this.dmlNameProvider);
            fromGenerator.cat(this.from.getRoot());
            Iterator<From.Join> joinIterator = this.from.getJoins().iterator();
            joinIterator.forEachRemaining(fromGenerator::cat);
            return result.toString();
        }

        @Override
        public PreparedSQL toPreparedSQL() {
            return this.toPreparedSQL(new StringAppender(), this.querySQLBuilderFactory.getParameterBinderRegistry());
        }

        public PreparedSQL toPreparedSQL(StringAppender sql, ColumnBinderRegistry parameterBinderRegistry) {
            PreparedSQLWrapper preparedSQLWrapper = new PreparedSQLWrapper(new StringAppenderWrapper(sql, this.dmlNameProvider), parameterBinderRegistry, this.dmlNameProvider);
            return this.toPreparedSQL(preparedSQLWrapper);
        }

        public PreparedSQL toPreparedSQL(final PreparedSQLWrapper preparedSQLWrapper) {
            if (this.from.getRoot() == null) {
                throw new IllegalArgumentException("Empty from");
            }
            FromGenerator fromGenerator = new FromGenerator(preparedSQLWrapper, this.dmlNameProvider){

                @Override
                void cat(Query query) {
                    QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = querySQLBuilderFactory.queryBuilder(query);
                    unionBuilder.toPreparedSQL(preparedSQLWrapper);
                }

                @Override
                void cat(Union.UnionInFrom union) {
                    UnionSQLBuilderFactory.UnionSQLBuilder unionSqlBuilder = new UnionSQLBuilderFactory.UnionSQLBuilder(union.getUnion(), querySQLBuilderFactory);
                    this.sql.cat("(", new String[0]);
                    unionSqlBuilder.toPreparedSQL(preparedSQLWrapper);
                    this.sql.cat(") as ", new String[0]).cat(this.getAliasOrDefault(union), new String[0]);
                }
            };
            fromGenerator.cat(this.from.getRoot());
            Iterator<From.Join> joinIterator = this.from.getJoins().iterator();
            joinIterator.forEachRemaining(fromGenerator::cat);
            PreparedSQL result = new PreparedSQL(preparedSQLWrapper.getSQL(), preparedSQLWrapper.getParameterBinders());
            result.setValues(preparedSQLWrapper.getValues());
            return result;
        }

        public class FromGenerator {
            private static final String INNER_JOIN = " inner join ";
            private static final String LEFT_OUTER_JOIN = " left outer join ";
            private static final String RIGHT_OUTER_JOIN = " right outer join ";
            private static final String CROSS_JOIN = " cross join ";
            private static final String ON = " on ";
            final SQLAppender sql;
            private final DMLNameProvider dmlNameProvider;

            public FromGenerator(SQLAppender sql, DMLNameProvider dmlNameProvider) {
                this.sql = sql;
                this.dmlNameProvider = dmlNameProvider;
            }

            public void cat(Object o) {
                if (o instanceof String) {
                    this.sql.cat((String)o, new String[0]);
                } else if (o instanceof Table) {
                    this.cat((Table)o);
                } else if (o instanceof Query) {
                    this.cat((Query)o);
                } else if (o instanceof Union.UnionInFrom) {
                    this.cat((Union.UnionInFrom)o);
                } else if (o instanceof From.CrossJoin) {
                    this.cat((From.CrossJoin)o);
                } else if (o instanceof From.AbstractJoin) {
                    this.cat((From.AbstractJoin)o);
                } else {
                    throw new UnsupportedOperationException("Unknown From element " + Reflections.toString(o.getClass()));
                }
            }

            private void cat(Table table) {
                String tableAlias = this.dmlNameProvider.getAlias(table);
                this.cat(table.getName());
                this.sql.catIf(!Strings.isEmpty((CharSequence)tableAlias), " as " + tableAlias);
            }

            void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = FromSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.toSQL(this.sql);
            }

            void cat(Union.UnionInFrom union) {
                UnionSQLBuilderFactory.UnionSQLBuilder unionSqlBuilder = new UnionSQLBuilderFactory.UnionSQLBuilder(union.getUnion(), FromSQLBuilder.this.querySQLBuilderFactory);
                this.sql.cat("(", new String[0]);
                unionSqlBuilder.toSQL(this.sql);
                this.sql.cat(") as ", new String[0]).cat(this.getAliasOrDefault(union), new String[0]);
            }

            private void cat(From.CrossJoin join) {
                this.sql.catIf(!this.sql.isEmpty(), CROSS_JOIN);
                this.cat(join.getRightTable());
            }

            private void cat(From.AbstractJoin join) {
                this.cat(join.getJoinDirection(), join.getRightTable());
                if (join instanceof From.RawTableJoin) {
                    this.cat(((From.RawTableJoin)join).getJoinClause());
                } else if (join instanceof From.ColumnJoin) {
                    From.ColumnJoin columnJoin = (From.ColumnJoin)join;
                    String leftPrefix = this.getAliasOrDefault((Fromable)columnJoin.getLeftColumn().getOwner());
                    String rightPrefix = this.getAliasOrDefault((Fromable)columnJoin.getRightColumn().getOwner());
                    this.sql.cat(leftPrefix.toString(), ".", columnJoin.getLeftColumn().getExpression(), " = ", rightPrefix.toString(), ".", columnJoin.getRightColumn().getExpression());
                } else if (join instanceof From.KeyJoin) {
                    From.KeyJoin keyJoin = (From.KeyJoin)join;
                    PairIterator joinColumnsPairs = new PairIterator(keyJoin.getLeftKey().getColumns(), keyJoin.getRightKey().getColumns());
                    joinColumnsPairs.forEachRemaining(duo -> {
                        String leftPrefix = this.getAliasOrDefault((Fromable)((JoinLink)duo.getLeft()).getOwner());
                        String rightPrefix = this.getAliasOrDefault((Fromable)((JoinLink)duo.getRight()).getOwner());
                        this.sql.cat(leftPrefix.toString(), ".", ((JoinLink)duo.getLeft()).getExpression(), " = ", rightPrefix.toString(), ".", ((JoinLink)duo.getRight()).getExpression(), " and ");
                    });
                    this.sql.removeLastChars(" and ".length());
                } else {
                    throw new UnsupportedOperationException("From building is not implemented for " + join.getClass().getName());
                }
            }

            String getAliasOrDefault(Fromable fromable) {
                return (String)Strings.preventEmpty((CharSequence)this.dmlNameProvider.getAlias(fromable), (CharSequence)fromable.getName());
            }

            protected void cat(From.AbstractJoin.JoinDirection joinDirection, Fromable table) {
                String joinType;
                switch (joinDirection) {
                    case INNER_JOIN: {
                        joinType = INNER_JOIN;
                        break;
                    }
                    case LEFT_OUTER_JOIN: {
                        joinType = LEFT_OUTER_JOIN;
                        break;
                    }
                    case RIGHT_OUTER_JOIN: {
                        joinType = RIGHT_OUTER_JOIN;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Join type not implemented");
                    }
                }
                this.sql.cat(joinType, new String[0]);
                this.cat(table);
                this.sql.cat(ON, new String[0]);
            }
        }
    }
}

