/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinChain;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.IdentityMap;

public class From
implements Iterable<Join>,
JoinChain<From> {
    private Fromable root;
    private final List<Join> joins = new ArrayList<Join>();
    private final IdentityMap<Fromable, String> tableAliases = new IdentityMap(4);

    public From(Fromable root) {
        this.root = root;
    }

    public From(Fromable root, String rootAlias) {
        this.setRoot(root, rootAlias);
    }

    public Fromable getRoot() {
        return this.root;
    }

    public From setRoot(Fromable root) {
        this.root = root;
        return this;
    }

    public From setRoot(Fromable root, String rootAlias) {
        this.root = root;
        this.setAlias(root, rootAlias);
        return this;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public IdentityMap<Fromable, String> getTableAliases() {
        return this.tableAliases;
    }

    @Override
    public <I> From innerJoin(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn) {
        return this.addNewJoin(leftColumn, rightColumn, AbstractJoin.JoinDirection.INNER_JOIN);
    }

    @Override
    public <JOINTYPE> From innerJoin(Key<?, JOINTYPE> leftColumns, Key<?, JOINTYPE> rightColumns) {
        return this.addNewJoin(leftColumns, rightColumns, AbstractJoin.JoinDirection.INNER_JOIN);
    }

    @Override
    public <I> From leftOuterJoin(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn) {
        return this.addNewJoin(leftColumn, rightColumn, AbstractJoin.JoinDirection.LEFT_OUTER_JOIN);
    }

    @Override
    public <JOINTYPE> From leftOuterJoin(Key<?, JOINTYPE> leftColumns, Key<?, JOINTYPE> rightColumns) {
        return this.addNewJoin(leftColumns, rightColumns, AbstractJoin.JoinDirection.LEFT_OUTER_JOIN);
    }

    @Override
    public <I> From rightOuterJoin(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn) {
        return this.addNewJoin(leftColumn, rightColumn, AbstractJoin.JoinDirection.RIGHT_OUTER_JOIN);
    }

    private <I> From addNewJoin(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn, AbstractJoin.JoinDirection joinDirection) {
        return this.add(new ColumnJoin(leftColumn, rightColumn, joinDirection));
    }

    private <JOINTYPE> From addNewJoin(Key<?, JOINTYPE> leftColumns, Key<?, JOINTYPE> rightColumns, AbstractJoin.JoinDirection joinDirection) {
        return this.add(new KeyJoin(leftColumns, rightColumns, joinDirection));
    }

    @Override
    public From innerJoin(Fromable rightTable, String joinClause) {
        return this.addNewJoin(rightTable, joinClause, AbstractJoin.JoinDirection.INNER_JOIN);
    }

    @Override
    public From innerJoin(Fromable rightTable, String rightTableAlias, String joinClause) {
        return this.addNewJoin(rightTable, rightTableAlias, joinClause, AbstractJoin.JoinDirection.INNER_JOIN);
    }

    @Override
    public From leftOuterJoin(Fromable rightTable, String joinClause) {
        return this.addNewJoin(rightTable, joinClause, AbstractJoin.JoinDirection.LEFT_OUTER_JOIN);
    }

    @Override
    public From leftOuterJoin(Fromable rightTable, String rightTableAlias, String joinClause) {
        return this.addNewJoin(rightTable, rightTableAlias, joinClause, AbstractJoin.JoinDirection.LEFT_OUTER_JOIN);
    }

    @Override
    public From rightOuterJoin(Fromable rightTable, String joinClause) {
        return this.addNewJoin(rightTable, joinClause, AbstractJoin.JoinDirection.RIGHT_OUTER_JOIN);
    }

    @Override
    public From rightOuterJoin(Fromable rightTable, String rightTableAlias, String joinClause) {
        return this.addNewJoin(rightTable, rightTableAlias, joinClause, AbstractJoin.JoinDirection.RIGHT_OUTER_JOIN);
    }

    @Override
    public From crossJoin(Fromable table) {
        CrossJoin crossJoin = new CrossJoin(table);
        this.add(crossJoin);
        return this;
    }

    @Override
    public From crossJoin(Fromable table, String tableAlias) {
        CrossJoin crossJoin = new CrossJoin(table, tableAlias);
        this.add(crossJoin);
        return this;
    }

    public From add(Fromable table) {
        CrossJoin crossJoin = new CrossJoin(table);
        return this.add(crossJoin);
    }

    public From add(Fromable table, String tableAlias) {
        CrossJoin crossJoin = new CrossJoin(table, tableAlias);
        return this.add(crossJoin);
    }

    private From addNewJoin(Fromable rightTable, String joinClause, AbstractJoin.JoinDirection joinDirection) {
        return this.add(new RawTableJoin(rightTable, null, joinClause, joinDirection));
    }

    private From addNewJoin(Fromable rightTable, String rightTableAlias, String joinClause, AbstractJoin.JoinDirection joinDirection) {
        return this.add(new RawTableJoin(rightTable, rightTableAlias, joinClause, joinDirection));
    }

    @Override
    public From setAlias(Fromable table, String alias) {
        if (!Strings.isEmpty((CharSequence)alias)) {
            this.tableAliases.put((Object)table, (Object)alias);
        }
        return this;
    }

    private From add(Join join) {
        this.joins.add(join);
        return this;
    }

    @Override
    public Iterator<Join> iterator() {
        return this.joins.iterator();
    }

    public class KeyJoin<JOINTYPE>
    extends AbstractJoin {
        private final Key<?, JOINTYPE> leftKey;
        private final Key<?, JOINTYPE> rightKey;

        private KeyJoin(Key<?, JOINTYPE> leftColumns, Key<?, JOINTYPE> rightColumns, AbstractJoin.JoinDirection joinDirection) {
            super(joinDirection);
            this.leftKey = leftColumns;
            this.rightKey = rightColumns;
        }

        public Key<?, JOINTYPE> getLeftKey() {
            return this.leftKey;
        }

        public Key<?, JOINTYPE> getRightKey() {
            return this.rightKey;
        }

        @Override
        public Fromable getRightTable() {
            return this.rightKey.getTable();
        }
    }

    public class ColumnJoin<I>
    extends AbstractJoin {
        private final JoinLink<?, I> leftColumn;
        private final JoinLink<?, I> rightColumn;

        private ColumnJoin(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn, AbstractJoin.JoinDirection joinDirection) {
            super(joinDirection);
            this.leftColumn = leftColumn;
            this.rightColumn = rightColumn;
        }

        public JoinLink<?, I> getLeftColumn() {
            return this.leftColumn;
        }

        public JoinLink<?, I> getRightColumn() {
            return this.rightColumn;
        }

        @Override
        public Fromable getRightTable() {
            return this.rightColumn.getOwner();
        }
    }

    public class RawTableJoin
    extends AbstractJoin {
        private final Fromable rightTable;
        private final String joinClause;

        private RawTableJoin(Fromable rightTable, String rightTableAlias, String joinClause, AbstractJoin.JoinDirection joinDirection) {
            super(joinDirection);
            this.rightTable = rightTable;
            this.joinClause = joinClause;
            From.this.setAlias(rightTable, rightTableAlias);
        }

        @Override
        public Fromable getRightTable() {
            return this.rightTable;
        }

        public String getJoinClause() {
            return this.joinClause;
        }
    }

    public class CrossJoin
    implements Join {
        private final Fromable rightTable;

        private CrossJoin(Fromable rightTable) {
            this.rightTable = rightTable;
        }

        private CrossJoin(Fromable table, String tableAlias) {
            this(table);
            this$0.setAlias(table, tableAlias);
        }

        @Override
        public Fromable getRightTable() {
            return this.rightTable;
        }

        public From crossJoin(Fromable table) {
            CrossJoin crossJoin = new CrossJoin(table);
            return From.this.add(crossJoin);
        }

        public From crossJoin(Fromable table, String alias) {
            CrossJoin crossJoin = new CrossJoin(table, alias);
            return From.this.add(crossJoin);
        }
    }

    public static abstract class AbstractJoin
    implements Join {
        private final JoinDirection joinDirection;

        protected AbstractJoin(JoinDirection joinDirection) {
            this.joinDirection = joinDirection;
        }

        public JoinDirection getJoinDirection() {
            return this.joinDirection;
        }

        public boolean isInner() {
            return this.joinDirection == JoinDirection.INNER_JOIN;
        }

        public boolean isLeftOuter() {
            return this.joinDirection == JoinDirection.LEFT_OUTER_JOIN;
        }

        public boolean isRightOuter() {
            return this.joinDirection == JoinDirection.RIGHT_OUTER_JOIN;
        }

        public static enum JoinDirection {
            INNER_JOIN,
            LEFT_OUTER_JOIN,
            RIGHT_OUTER_JOIN;

        }
    }

    public static interface Join {
        public Fromable getRightTable();
    }
}

