/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.lang.reflect.Field;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.configurer.PropertyAccessorResolver;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.function.ThreadSafeLazyInitializer;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ValueAccessPointVariantSupport<T, O> {
    private final ThreadSafeLazyInitializer<ReversibleAccessor<T, O>> accessor;
    private SerializableFunction<T, O> getter;
    private SerializableBiConsumer<T, O> setter;
    private Field field;

    public ValueAccessPointVariantSupport(SerializableFunction<T, O> getter) {
        this.getter = getter;
        this.accessor = new AccessorFieldLazyInitializer();
    }

    public ValueAccessPointVariantSupport(SerializableBiConsumer<T, O> setter) {
        this.setter = setter;
        this.accessor = new AccessorFieldLazyInitializer();
    }

    public ValueAccessPointVariantSupport(final Class persistedClass, final String fieldName) {
        this.accessor = new ThreadSafeLazyInitializer<ReversibleAccessor<T, O>>(){

            protected ReversibleAccessor<T, O> createInstance() {
                return new AccessorByField(Reflections.getField((Class)persistedClass, (String)fieldName));
            }
        };
    }

    public void setField(Class persistedClass, String fieldName) {
        this.field = Reflections.getField((Class)persistedClass, (String)fieldName);
    }

    public ReversibleAccessor<T, O> getAccessor() {
        return (ReversibleAccessor)this.accessor.get();
    }

    private class AccessorFieldLazyInitializer
    extends ThreadSafeLazyInitializer<ReversibleAccessor<T, O>> {
        private AccessorFieldLazyInitializer() {
        }

        protected ReversibleAccessor<T, O> createInstance() {
            return new PropertyAccessorResolver(new PropertyAccessorResolver.PropertyMapping<T, O>(){

                @Override
                public SerializableFunction<T, O> getGetter() {
                    return ValueAccessPointVariantSupport.this.getter;
                }

                @Override
                public SerializableBiConsumer<T, O> getSetter() {
                    return ValueAccessPointVariantSupport.this.setter;
                }

                @Override
                public Field getField() {
                    return ValueAccessPointVariantSupport.this.field;
                }
            }).resolve();
        }
    }
}

