/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.idprovider;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.idprovider.PooledIdentifierProvider;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

public class PooledIdentifierProviderTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchronousLoad() throws InterruptedException {
        List starterKit = Arrays.asList((Object[])new Long[]{1L, 2L, 3L});
        final ArrayList generated = new ArrayList(500);
        generated.addAll(starterKit);
        ExecutorService backgroundLoader = Executors.newSingleThreadExecutor();
        PooledIdentifierProvider<Long> testInstance = new PooledIdentifierProvider<Long>((Collection)starterKit, 2, (Executor)backgroundLoader, Duration.ofSeconds(2L)){
            private long seed;
            {
                super(x0, x1, x2, x3);
                this.seed = 4L;
            }

            protected Collection<Long> retrieveSomeValues() {
                ArrayList<Long> result = new ArrayList<Long>();
                for (long i = 0L; i < 10L; ++i) {
                    result.add(this.seed++);
                }
                generated.addAll(result);
                return result;
            }
        };
        ArrayList result = new ArrayList();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        executorService.submit(new QueueConsumer((PooledIdentifierProvider)testInstance, result));
        executorService.submit(new QueueConsumer((PooledIdentifierProvider)testInstance, result));
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        backgroundLoader.shutdown();
        backgroundLoader.awaitTermination(2L, TimeUnit.SECONDS);
        ArrayList arrayList = result;
        synchronized (arrayList) {
            result.sort(Long::compareTo);
            Assertions.assertThat(new ArrayList(new HashSet(result))).isEqualTo(result);
            Assertions.assertThat((boolean)generated.containsAll(result)).isTrue();
        }
    }

    private class QueueConsumer
    implements Runnable {
        private final List<Long> bagToFill;
        private final PooledIdentifierProvider<Long> testInstance;

        private QueueConsumer(PooledIdentifierProvider<Long> testInstance, List<Long> bagToFill) {
            this.bagToFill = bagToFill;
            this.testInstance = testInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        long data = (Long)this.testInstance.giveNewIdentifier();
                        List<Long> list = this.bagToFill;
                        synchronized (list) {
                            this.bagToFill.add(data);
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }
}

