/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntitySelector;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class TablePerClassPolymorphismEntitySelector<C, I, T extends Table<T>>
extends AbstractPolymorphicEntitySelector<C, I, T> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    static final Selectable.SelectableString<String> DISCRIMINATOR_COLUMN = new Selectable.SelectableString("DISCRIMINATOR", String.class);
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final T mainTable;
    private final Map<String, Class> discriminatorValues;
    private final SingleLoadEntityJoinTree<C, I> singleLoadEntityJoinTree;
    private final PhasedEntityJoinTree<C, I> phasedLoadEntityJoinTree;

    public TablePerClassPolymorphismEntitySelector(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister.getEntityJoinTree(), persisterPerSubclass, connectionProvider, dialect);
        this.mainPersister = mainPersister;
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.mainTable = mainPersister.getMainTable();
        this.discriminatorValues = new HashMap<String, Class>();
        persisterPerSubclass.forEach((subEntityType, subEntityTable) -> this.discriminatorValues.put(subEntityType.getSimpleName(), (Class)subEntityType));
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree();
        this.phasedLoadEntityJoinTree = this.build2PhasesLoadEntityJoinTree();
    }

    private SingleLoadEntityJoinTree<C, I> buildSingleLoadEntityJoinTree() {
        Union union = new Union(new Query[0]);
        Set allColumnsInHierarchy = (Set)Collections.cat((Collection[])new Collection[]{Arrays.asList((Object[])new ConfiguredRelationalPersister[]{this.mainPersister}), this.persisterPerSubclass.values()}).stream().flatMap(persister -> persister.getMainTable().getColumns().stream()).map(column -> new Selectable.SelectableString(column.getExpression(), column.getJavaType())).collect(Collectors.toCollection(KeepOrderSet::new));
        HashMap discriminatorPerSubPersister = new HashMap();
        this.persisterPerSubclass.forEach((subEntityType, subEntityPersister) -> {
            String discriminatorValue = subEntityType.getSimpleName();
            subEntityPersister.getMainTable().getColumns();
            KeepOrderMap subQueryColumns = new KeepOrderMap();
            allColumnsInHierarchy.forEach(arg_0 -> TablePerClassPolymorphismEntitySelector.lambda$null$3(subEntityPersister, (Map)subQueryColumns, arg_0));
            Query query = (Query)QueryEase.select((Map)subQueryColumns).add("'" + discriminatorValue + "'", String.class).as(DISCRIMINATOR_ALIAS).from((Fromable)subEntityPersister.getMainTable()).getQuery();
            union.getQueries().add((Object)query);
            query.getColumns().forEach(arg_0 -> TablePerClassPolymorphismEntitySelector.lambda$null$4(union, (Map)subQueryColumns, arg_0));
            discriminatorPerSubPersister.put(discriminatorValue, subEntityPersister);
        });
        union.registerColumn(DISCRIMINATOR_COLUMN.getExpression(), String.class, DISCRIMINATOR_ALIAS);
        Union.UnionInFrom pseudoTable = union.asPseudoTable(this.mainTable.getName());
        SingleLoadEntityJoinTree<C, I> result = new SingleLoadEntityJoinTree<C, I>(this.mainPersister, discriminatorPerSubPersister, pseudoTable, allColumnsInHierarchy);
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        return result;
    }

    private PhasedEntityJoinTree<C, I> build2PhasesLoadEntityJoinTree() {
        Map aliasPerColumnName = Iterables.map((Iterable)this.mainTable.getColumns(), Column::getName, Column::getName);
        Union union = new Union(new Query[0]);
        this.persisterPerSubclass.forEach((subEntityType, subEntityPersister) -> {
            String discriminatorValue = subEntityType.getSimpleName();
            Query query = this.buildSubConfigurationQuery(discriminatorValue, this.mainTable, subEntityPersister.getMainTable(), aliasPerColumnName);
            union.getQueries().add((Object)query);
            query.getColumns().stream().filter(column -> !column.getExpression().equals(discriminatorValue)).forEach(column -> union.registerColumn(column.getExpression(), column.getJavaType()));
        });
        Union.UnionInFrom pseudoTable = union.asPseudoTable(this.mainTable.getName());
        PhasedEntityJoinTree result = new PhasedEntityJoinTree(pseudoTable, (Table)this.mainTable);
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        return result;
    }

    private <SUBTABLE extends Table<SUBTABLE>> Query buildSubConfigurationQuery(String discriminatorValue, T mainTable, SUBTABLE subEntityTable, Map<String, String> aliasPerColumnName) {
        Map aliasPerColumn = Iterables.map((Iterable)mainTable.getColumns(), column -> subEntityTable.getColumn(column.getName()), c -> (String)aliasPerColumnName.get(c.getName()), KeepOrderMap::new);
        return (Query)QueryEase.select((Map)aliasPerColumn).add("'" + discriminatorValue + "'", String.class).as(DISCRIMINATOR_ALIAS).from(subEntityTable).getQuery();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        IdentityHashMap<Selectable<?>, Selectable<?>> columnClones = entityTreeQuery.getColumnClones();
        IdentityHashMap originalColumnsToClones = new IdentityHashMap(columnClones.size());
        originalColumnsToClones.putAll(columnClones);
        originalColumnsToClones.putAll(this.singleLoadEntityJoinTree.getMainColumnToPseudoColumn());
        originalColumnsToClones.put((Selectable<?>)DISCRIMINATOR_COLUMN, (Selectable<?>)DISCRIMINATOR_COLUMN);
        orderByClauseConsumer.accept(new AbstractPolymorphicEntitySelector.ColumnCloneAwareOrderBy(query.orderBy(), originalColumnsToClones));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), originalColumnsToClones);
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, entityTreeQuery.getSelectParameterBinders());
            Set<C> set = inflater.transform(() -> rowIterator, 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.phasedLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        IdentityHashMap<Selectable<?>, Selectable<?>> columnClones = entityTreeQuery.getColumnClones();
        IdentityHashMap originalColumnsToClones = new IdentityHashMap(columnClones.size());
        originalColumnsToClones.putAll(columnClones);
        originalColumnsToClones.putAll(this.phasedLoadEntityJoinTree.getMainColumnToPseudoColumn());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), originalColumnsToClones);
        query.getSelectSurrogate().clear();
        this.mainTable.getPrimaryKey().getColumns().forEach(pkColumn -> {
            Selectable column = this.mainEntityJoinTree.getRoot().getTable().findColumn(pkColumn.getName());
            query.select(column, pkColumn.getName());
        });
        query.select(DISCRIMINATOR_COLUMN, new Selectable[0]);
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader reader = selectable instanceof Column ? this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable)) : this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            columnReaders.put((String)s, reader);
        });
        this.mainTable.getColumns().forEach(column -> aliases.put(column, column.getName()));
        columnReaders.put(DISCRIMINATOR_ALIAS, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder(String.class));
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        orderByClauseConsumer.accept(new AbstractPolymorphicEntitySelector.ColumnCloneAwareOrderBy(query.orderBy(), originalColumnsToClones));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        Map<Class, Set<I>> idsPerSubclass = this.readIds(sqlQueryBuilder.toPreparedSQL(), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subClass, subEntityIds) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(subClass)).select((Iterable)subEntityIds)));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            KeepOrderMap idsPerSubclass = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$17((Map)idsPerSubclass, columnedRow, arg_0));
            KeepOrderMap keepOrderMap = idsPerSubclass;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectSurrogate().setDistinct(distinct);
        IdentityHashMap<Selectable<?>, Selectable<?>> columnClones = entityTreeQuery.getColumnClones();
        IdentityHashMap originalColumnsToClones = new IdentityHashMap(columnClones.size());
        originalColumnsToClones.putAll(columnClones);
        originalColumnsToClones.putAll(this.singleLoadEntityJoinTree.getMainColumnToPseudoColumn());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where, originalColumnsToClones);
        selectAdapter.accept(query.getSelectSurrogate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AbstractPolymorphicEntitySelector.AliasAsserter<Selectable>(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    private /* synthetic */ void lambda$readIds$17(Map idsPerSubclass, ColumnedRow columnedRow, Row row) {
        String discriminatorValue = (String)row.get(DISCRIMINATOR_ALIAS);
        Class entitySubclass = this.discriminatorValues.get(discriminatorValue.trim());
        idsPerSubclass.computeIfAbsent(entitySubclass, k -> new HashSet()).add(this.identifierAssembler.assemble(row, columnedRow));
    }

    private static /* synthetic */ void lambda$null$4(Union union, Map subQueryColumns, Selectable column) {
        union.registerColumn(column.getExpression(), column.getJavaType(), (String)subQueryColumns.get(column));
    }

    private static /* synthetic */ void lambda$null$3(ConfiguredRelationalPersister subEntityPersister, Map subQueryColumns, Selectable pseudoColumn) {
        Column column = subEntityPersister.getMainTable().findColumn(pseudoColumn.getExpression());
        if (column != null) {
            subQueryColumns.put(column, column.getName());
        } else {
            subQueryColumns.put(Operators.cast((String)null, (Class)pseudoColumn.getJavaType()), pseudoColumn.getExpression());
        }
    }

    private static class SingleLoadEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        private final IdentityHashMap<Column<?, ?>, Selectable<?>> mainColumnToPseudoColumn = new IdentityHashMap();

        public <T extends Table<T>> SingleLoadEntityJoinTree(final ConfiguredRelationalPersister<C, I> mainPersister, final Map<String, ConfiguredRelationalPersister<C, I>> discriminatorPerSubPersister, Union.UnionInFrom pseudoTable, final Set<Selectable<?>> allColumnInHierarchy) {
            super(new EntityInflater<C, I>(){

                @Override
                public Class<C> getEntityType() {
                    return mainPersister.getClassToPersist();
                }

                @Override
                public I giveIdentifier(Row row, ColumnedRow columnedRow) {
                    return mainPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
                }

                @Override
                public RowTransformer<C> copyTransformerWithAliases(final ColumnedRow columnedRow) {
                    final Map rowTransformerPerDiscriminator = Iterables.map(discriminatorPerSubPersister.entrySet(), Map.Entry::getKey, entry -> ((ConfiguredRelationalPersister)entry.getValue()).getMapping().copyTransformerWithAliases(columnedRow));
                    return new RowTransformer<C>(){

                        public C transform(Row row) {
                            String value = (String)columnedRow.getValue(DISCRIMINATOR_COLUMN, row);
                            return ((RowTransformer)rowTransformerPerDiscriminator.get(value.trim())).transform(row);
                        }

                        public void applyRowToBean(Row row, C bean) {
                        }

                        public AbstractTransformer<C> copyWithAliases(ColumnedRow columnedRow2) {
                            throw new IllegalStateException("copyWithAliases(..) is not expected to be called twice");
                        }

                        public void addTransformerListener(RowTransformer.TransformerListener<? extends C> listener) {
                        }
                    };
                }

                @Override
                public Set<Selectable<?>> getSelectableColumns() {
                    KeepOrderSet result = new KeepOrderSet((Collection)allColumnInHierarchy);
                    result.add(DISCRIMINATOR_COLUMN);
                    return result;
                }
            }, (Fromable)pseudoTable);
            pseudoTable.getColumns().forEach(pseudoColumn -> {
                Column column = mainPersister.getMainTable().findColumn(pseudoColumn.getExpression());
                if (column != null) {
                    this.mainColumnToPseudoColumn.put((Column<?, ?>)column, (Selectable<?>)pseudoColumn);
                }
            });
        }

        @Override
        public JoinRoot<C, I, Union.UnionInFrom> getRoot() {
            return super.getRoot();
        }

        public IdentityHashMap<Column<?, ?>, Selectable<?>> getMainColumnToPseudoColumn() {
            return this.mainColumnToPseudoColumn;
        }
    }

    private static class PhasedEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        private final IdentityHashMap<Column<?, ?>, Selectable<?>> mainColumnToPseudoColumn = new IdentityHashMap();

        private PhasedEntityJoinTree(final Union.UnionInFrom pseudoTable, Table mainTable) {
            super(new EntityInflater<C, I>(){

                @Override
                public Class<C> getEntityType() {
                    return null;
                }

                @Override
                public I giveIdentifier(Row row, ColumnedRow columnedRow) {
                    return null;
                }

                @Override
                public RowTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
                    return null;
                }

                @Override
                public Set<Selectable<?>> getSelectableColumns() {
                    return pseudoTable.getColumns();
                }
            }, (Fromable)pseudoTable);
            pseudoTable.getColumns().forEach(pseudoColumn -> {
                Column column = mainTable.findColumn(pseudoColumn.getExpression());
                if (column != null) {
                    this.mainColumnToPseudoColumn.put((Column<?, ?>)column, (Selectable<?>)pseudoColumn);
                }
            });
        }

        @Override
        public JoinRoot<C, I, Union.UnionInFrom> getRoot() {
            return super.getRoot();
        }

        public IdentityHashMap<Column<?, ?>, Selectable<?>> getMainColumnToPseudoColumn() {
            return this.mainColumnToPseudoColumn;
        }
    }
}

