/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.UnionSQLBuilderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;

public class Dialect {
    private final SqlTypeRegistry sqlTypeRegistry;
    private final ColumnBinderRegistry columnBinderRegistry;
    private int inOperatorMaxSize = 1000;
    private final DDLTableGenerator ddlTableGenerator;
    private final DMLGenerator dmlGenerator;
    private final WriteOperationFactory writeOperationFactory;
    private final ReadOperationFactory readOperationFactory;
    private QuerySQLBuilderFactory querySQLBuilderFactory;
    private UnionSQLBuilderFactory unionSQLBuilderFactory;

    public Dialect() {
        this((JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
    }

    public Dialect(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this(javaTypeToSqlTypeMapping, new ColumnBinderRegistry());
    }

    public Dialect(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, ColumnBinderRegistry columnBinderRegistry) {
        this.sqlTypeRegistry = new SqlTypeRegistry(javaTypeToSqlTypeMapping);
        this.columnBinderRegistry = columnBinderRegistry;
        this.dmlGenerator = this.newDmlGenerator(columnBinderRegistry);
        this.ddlTableGenerator = this.newDdlTableGenerator();
        this.writeOperationFactory = this.newWriteOperationFactory();
        this.readOperationFactory = this.newReadOperationFactory();
        this.querySQLBuilderFactory = new QuerySQLBuilderFactoryBuilder(columnBinderRegistry, javaTypeToSqlTypeMapping).build();
        this.unionSQLBuilderFactory = new UnionSQLBuilderFactory();
    }

    protected DDLTableGenerator newDdlTableGenerator() {
        return new DDLTableGenerator(this.getSqlTypeRegistry());
    }

    public DDLTableGenerator getDdlTableGenerator() {
        return this.ddlTableGenerator;
    }

    protected DMLGenerator newDmlGenerator(ColumnBinderRegistry columnBinderRegistry) {
        return new DMLGenerator(columnBinderRegistry);
    }

    public DMLGenerator getDmlGenerator() {
        return this.dmlGenerator;
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new WriteOperationFactory();
    }

    public WriteOperationFactory getWriteOperationFactory() {
        return this.writeOperationFactory;
    }

    protected ReadOperationFactory newReadOperationFactory() {
        return new ReadOperationFactory();
    }

    public ReadOperationFactory getReadOperationFactory() {
        return this.readOperationFactory;
    }

    public QuerySQLBuilderFactory getQuerySQLBuilderFactory() {
        return this.querySQLBuilderFactory;
    }

    public UnionSQLBuilderFactory getUnionSQLBuilderFactory() {
        return this.unionSQLBuilderFactory;
    }

    public void setQuerySQLBuilderFactory(QuerySQLBuilderFactory querySQLBuilderFactory) {
        this.querySQLBuilderFactory = querySQLBuilderFactory;
    }

    public SqlTypeRegistry getSqlTypeRegistry() {
        return this.sqlTypeRegistry;
    }

    public ColumnBinderRegistry getColumnBinderRegistry() {
        return this.columnBinderRegistry;
    }

    public int getInOperatorMaxSize() {
        return this.inOperatorMaxSize;
    }

    public void setInOperatorMaxSize(int inOperatorMaxSize) {
        if (inOperatorMaxSize <= 0) {
            throw new IllegalArgumentException("SQL operator 'in' must contain at least 1 element");
        }
        this.inOperatorMaxSize = inOperatorMaxSize;
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new GeneratedKeysReader(keyName, (ResultSetReader)this.getColumnBinderRegistry().getBinder(columnType));
    }

    public boolean supportsTupleCondition() {
        return false;
    }
}

