/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.codefilarete.stalactite.query.model.FluentSelect;
import org.codefilarete.stalactite.query.model.SelectChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.reflect.MethodDispatcher;

public class Select
implements FluentSelect<Select> {
    private final KeepOrderMap<Selectable<?>, String> columns = new KeepOrderMap();
    private boolean distinct = false;

    public KeepOrderSet<Selectable<?>> getColumns() {
        return new KeepOrderSet((Collection)this.columns.keySet());
    }

    @Override
    public Select add(Iterable<? extends Selectable<?>> expressions) {
        expressions.forEach(this::add);
        return this;
    }

    @Override
    public Select add(Selectable<?> expression, Selectable<?> ... expressions) {
        this.add(expression);
        for (Selectable<?> expr : expressions) {
            this.add(expr);
        }
        return this;
    }

    @Override
    public SelectChain.AliasableExpression<Select> add(String expression, Class<?> javaType) {
        Selectable.SelectableString selectable = new Selectable.SelectableString(expression, javaType);
        this.add(selectable);
        return (SelectChain.AliasableExpression)new MethodDispatcher().redirect(SelectChain.Aliasable.class, alias -> {
            this.columns.put((Object)selectable, (Object)alias);
            return null;
        }, (Object)this).redirect(SelectChain.class, (Object)this).build(SelectChain.AliasableExpression.class);
    }

    @Override
    public Select add(Selectable<?> column, String alias) {
        this.columns.put(column, (Object)alias);
        return this;
    }

    @Override
    public Select add(Map<? extends Selectable<?>, String> aliasedColumns) {
        this.columns.putAll(aliasedColumns);
        return this;
    }

    public Select remove(Selectable<?> selectable) {
        this.columns.remove(selectable);
        return this;
    }

    public Map<Selectable<?>, String> getAliases() {
        KeepOrderMap result = new KeepOrderMap();
        result.putAll(this.columns);
        result.values().remove(null);
        return result;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public Select distinct() {
        this.distinct = true;
        return this;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public KeepOrderMap<Selectable<?>, String> clear() {
        KeepOrderMap result = new KeepOrderMap(this.columns);
        this.columns.clear();
        return result;
    }

    @Override
    public Iterator<Selectable<?>> iterator() {
        return this.columns.keySet().iterator();
    }
}

