/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.LongSupplier;
import org.codefilarete.stalactite.engine.StaleStateObjectException;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class WriteOperationFactory {
    public static final WriteOperation.RowCountListener NOOP_COUNT_CHECKER = new NoopRowCountListener();

    public <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider) {
        return this.createInstance(sqlGenerator, connectionProvider, NOOP_COUNT_CHECKER);
    }

    public <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, long expectedRowCount) {
        return this.createInstance(sqlGenerator, connectionProvider, () -> expectedRowCount);
    }

    public <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, LongSupplier expectedRowCount) {
        return this.createInstance(sqlGenerator, connectionProvider, new JDBCRowCountChecker(expectedRowCount));
    }

    protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
        return this.createInstance(sqlGenerator, connectionProvider, (ThrowingBiFunction<Connection, String, PreparedStatement, SQLException>)((ThrowingBiFunction)Connection::prepareStatement), rowCountListener);
    }

    public <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, long expectedRowCount) {
        return this.createInstance(sqlGenerator, connectionProvider, statementProvider, () -> expectedRowCount);
    }

    public <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, LongSupplier expectedRowCount) {
        return this.createInstance(sqlGenerator, connectionProvider, statementProvider, new JDBCRowCountChecker(expectedRowCount));
    }

    public <T extends Table<T>> WriteOperation<Column<T, Object>> createInstanceForInsertion(ColumnParameterizedSQL<T> sqlGenerator, ConnectionProvider connectionProvider, LongSupplier expectedRowCount) {
        return this.createInstance((SQLStatement)sqlGenerator, connectionProvider, (ThrowingBiFunction<Connection, String, PreparedStatement, SQLException>)((ThrowingBiFunction)(connection, sql) -> connection.prepareStatement((String)sql, 1)), new JDBCRowCountChecker(expectedRowCount));
    }

    protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
        return new WriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

            protected void prepareStatement(Connection connection) throws SQLException {
                this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
            }
        };
    }

    public static class ExpectedBatchedRowCountsSupplier
    implements LongSupplier {
        private final int lastPacketNumber;
        private int packetNumber = 0;
        private final int lastPacketSize;
        private final int packetSize;

        public ExpectedBatchedRowCountsSupplier(int entityCount, int batchSize) {
            this.lastPacketNumber = entityCount / batchSize;
            this.packetSize = batchSize;
            this.lastPacketSize = entityCount % batchSize;
        }

        @Override
        public long getAsLong() {
            return this.packetNumber++ == this.lastPacketNumber ? (long)this.lastPacketSize : (long)this.packetSize;
        }
    }

    public static class JDBCRowCountChecker
    implements WriteOperation.RowCountListener {
        private final LongSupplier expectedRowCount;

        public JDBCRowCountChecker(LongSupplier expectedRowCount) {
            this.expectedRowCount = expectedRowCount;
        }

        public JDBCRowCountChecker(long expectedRowCount) {
            this(() -> expectedRowCount);
        }

        public void onRowCounts(long[] writeCounts) {
            long writeCount = 0L;
            int successNoInfoCount = 0;
            int failureCount = 0;
            for (long count : writeCounts) {
                if (count == -2L) {
                    ++successNoInfoCount;
                    continue;
                }
                if (count == -3L) {
                    ++failureCount;
                    continue;
                }
                writeCount += count;
            }
            long expectedRowCount = this.expectedRowCount.getAsLong();
            if (successNoInfoCount != writeCounts.length && (failureCount != 0 || expectedRowCount != writeCount)) {
                throw new StaleStateObjectException(expectedRowCount, writeCount);
            }
        }

        public void onRowCount(long writeCount) {
            if (this.expectedRowCount.getAsLong() != writeCount) {
                throw new StaleStateObjectException(this.expectedRowCount.getAsLong(), writeCount);
            }
        }
    }

    protected static class NoopRowCountListener
    implements WriteOperation.RowCountListener {
        protected NoopRowCountListener() {
        }

        public void onRowCount(long writeCount) {
        }
    }
}

