/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SQLStatementTest {
    @Test
    public void testApplyValue_missingBinder_exceptionIsThrown() {
        SQLStatementStub testInstance = new SQLStatementStub((Map<String, PreparedStatementWriter>)Maps.asMap((Object)"a", (Object)DefaultParameterBinders.INTEGER_BINDER));
        testInstance.setValues((Map)Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalArgumentException.class).as("Missing binder for [b] for values {a=1, b=2} in \"dummy sql\"", new Object[0])).isThrownBy(() -> testInstance.applyValues((PreparedStatement)Mockito.mock(PreparedStatement.class)));
    }

    @Test
    public void testApplyValue_missingValue_exceptionIsThrown() {
        SQLStatementStub testInstance = new SQLStatementStub((Map<String, PreparedStatementWriter>)Maps.asMap((Object)"a", (Object)DefaultParameterBinders.INTEGER_BINDER));
        testInstance.setValues((Map)Maps.asMap((Object)"b", (Object)2));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalArgumentException.class).as("Missing value for parameters [a] in values {b=2} in \"dummy sql\"", new Object[0])).isThrownBy(() -> testInstance.applyValues((PreparedStatement)Mockito.mock(PreparedStatement.class)));
    }

    @Test
    public void testApplyValue_allBindersPresent_doApplyValueIsCalled() {
        final HashMap appliedValues = new HashMap();
        SQLStatementStub testInstance = new SQLStatementStub((Map)Maps.asMap((Object)"a", (Object)DefaultParameterBinders.INTEGER_BINDER).add((Object)"b", (Object)DefaultParameterBinders.INTEGER_BINDER)){

            @Override
            protected void doApplyValue(String key, Object value, PreparedStatement statement) {
                appliedValues.put(key, value);
            }
        };
        Maps.ChainingMap expectedValues = Maps.asMap((Object)"a", (Object)1).add((Object)"b", (Object)2);
        testInstance.setValues((Map)expectedValues);
        testInstance.applyValues((PreparedStatement)Mockito.mock(PreparedStatement.class));
        Assertions.assertThat(appliedValues).isEqualTo((Object)expectedValues);
    }

    private static class SQLStatementStub
    extends SQLStatement<String> {
        public SQLStatementStub(Map<String, PreparedStatementWriter> paramBinders) {
            super(paramBinders);
        }

        public String getSQL() {
            return "dummy sql";
        }

        protected void doApplyValue(String key, Object value, PreparedStatement statement) {
        }
    }
}

