/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntitySelector;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinTableRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.KeepOrderMap;

public class JoinTablePolymorphismEntitySelector<C, I, T extends Table<T>>
extends AbstractPolymorphicEntitySelector<C, I, T> {
    private final T mainTable;
    private final SingleLoadEntityJoinTree<C, I> singleLoadEntityJoinTree;

    public JoinTablePolymorphismEntitySelector(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister.getEntityJoinTree(), persisterPerSubclass, connectionProvider, dialect);
        this.mainTable = mainPersister.getMainTable();
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister, persisterPerSubclass);
    }

    private SingleLoadEntityJoinTree<C, I> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass) {
        SingleLoadEntityJoinTree result = new SingleLoadEntityJoinTree(mainPersister, new HashSet<ConfiguredRelationalPersister<C, I>>(persisterPerSubclass.values()));
        persisterPerSubclass.forEach((type, persister) -> result.addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(persister.getMapping()), mainPersister.getMainTable().getPrimaryKey(), persister.getMainTable().getPrimaryKey(), EntityJoinTree.JoinType.OUTER, columnedRow -> {
            MergeJoinNode.MergeJoinRowConsumer subEntityConsumer = new MergeJoinNode.MergeJoinRowConsumer(persister.getMapping().copyTransformerWithAliases(columnedRow));
            ((JoinTableRootJoinNode)result.getRoot()).addSubPersister(persister, subEntityConsumer, (ColumnedRow)columnedRow);
            return subEntityConsumer;
        }));
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        return result;
    }

    @Override
    Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        return super.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer, this.singleLoadEntityJoinTree, this.dialect, this.connectionProvider);
    }

    @Override
    Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery entityTreeQuery = new EntityTreeQueryBuilder(this.mainEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        this.persisterPerSubclass.values().forEach(subclassPersister -> {
            query.getFrom().leftOuterJoin((Key)this.mainTable.getPrimaryKey(), (Key)subclassPersister.getMainTable().getPrimaryKey());
            subclassPersister.getMainTable().getPrimaryKey().getColumns().forEach(column -> query.select((Selectable)column, column.getAlias()));
        });
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((String)s, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        orderByClauseConsumer.accept(new AbstractPolymorphicEntitySelector.ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones()));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparedSQL(), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubtype.forEach((k, v) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(k)).select((Iterable)v)));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        KeepOrderMap result = new KeepOrderMap();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator resultSetIterator = new RowIterator(resultSet, columnReaders);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$readIds$7(columnedRow, (Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$7(ColumnedRow columnedRow, Map result, Row row) {
        Set entries = this.persisterPerSubclass.entrySet();
        Duo duo = null;
        for (Map.Entry entry : entries) {
            Object identifier = ((ConfiguredRelationalPersister)entry.getValue()).getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
            if (identifier == null) continue;
            duo = new Duo(entry.getKey(), identifier);
            break;
        }
        result.computeIfAbsent(duo.getLeft(), k -> new HashSet()).add(duo.getRight());
    }

    private static class SingleLoadEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters) {
            super(tree -> new JoinTableRootJoinNode(tree, mainPersister, subPersisters, mainPersister.getMapping().getSelectableColumns(), mainPersister.getMainTable()));
        }
    }
}

