/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.collection.Iterables;

public abstract class AbstractPolymorphicEntitySelector<C, I, T extends Table<T>>
implements EntitySelector<C, I> {
    protected final EntityJoinTree<C, I> mainEntityJoinTree;
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    protected final ConnectionProvider connectionProvider;
    protected final Dialect dialect;

    protected AbstractPolymorphicEntitySelector(EntityJoinTree<C, I> mainEntityJoinTree, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainEntityJoinTree = mainEntityJoinTree;
        this.persisterPerSubclass = persisterPerSubclass;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        if (where.hasCollectionCriteria()) {
            return this.selectIn2Phases(where, orderByClauseConsumer, limitAwareConsumer);
        }
        return this.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer);
    }

    abstract Set<C> selectIn2Phases(ConfiguredEntityCriteria var1, Consumer<OrderByChain<?>> var2, Consumer<LimitAware<?>> var3);

    abstract Set<C> selectWithSingleQuery(ConfiguredEntityCriteria var1, Consumer<OrderByChain<?>> var2, Consumer<LimitAware<?>> var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer, EntityJoinTree<C, I> entityJoinTree, Dialect dialect, ConnectionProvider connectionProvider) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(entityJoinTree, (ResultSetReaderRegistry)dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        orderByClauseConsumer.accept(new ColumnCloneAwareOrderBy(query.orderBy(), entityTreeQuery.getColumnClones()));
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = dialect.getQuerySQLBuilderFactory().queryBuilder(query, where.getCriteria(), entityTreeQuery.getColumnClones());
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, entityTreeQuery.getSelectParameterBinders());
            Set<C> set = inflater.transform(() -> rowIterator, 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.mainEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectSurrogate().setDistinct(distinct);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where, entityTreeQuery.getColumnClones());
        selectAdapter.accept(query.getSelectSurrogate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AliasAsserter<Selectable>(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R, O> R readProjection(PreparedSQL preparedSQL, Map<String, ResultSetReader<?>> columnReaders, ColumnedRow columnedRow, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> selectable -> columnedRow.getValue(selectable, row)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    protected static class ColumnCloneAwareOrderBy
    implements OrderByChain {
        private final OrderByChain delegate;
        private final IdentityHashMap<Selectable<?>, Selectable<?>> columnClones;

        protected ColumnCloneAwareOrderBy(Query.FluentOrderByClause delegate, IdentityHashMap<Selectable<?>, Selectable<?>> columnClones) {
            this.delegate = delegate;
            this.columnClones = columnClones;
        }

        public OrderByChain add(Selectable column, OrderByChain.Order order) {
            return this.delegate.add(this.getColumn(column), order);
        }

        private Selectable getColumn(Selectable column) {
            return this.columnClones.get(column);
        }

        public OrderByChain add(Selectable col1, OrderByChain.Order order1, Selectable col2, OrderByChain.Order order2) {
            return this.delegate.add(this.getColumn(col1), order1, this.getColumn(col2), order2);
        }

        public OrderByChain add(Selectable col1, OrderByChain.Order order1, Selectable col2, OrderByChain.Order order2, Selectable col3, OrderByChain.Order order3) {
            return this.delegate.add(this.getColumn(col1), order1, this.getColumn(col2), order2, this.getColumn(col3), order3);
        }

        public OrderByChain add(String column, OrderByChain.Order order) {
            return this.delegate.add(column, order);
        }

        public OrderByChain add(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2) {
            return this.delegate.add(col1, order1, col2, order2);
        }

        public OrderByChain add(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2, String col3, OrderByChain.Order order3) {
            return this.delegate.add(col1, order1, col2, order2, col3, order3);
        }

        public OrderByChain add(Selectable column, Selectable ... columns) {
            return this.delegate.add(this.getColumn(column), (Selectable[])Arrays.stream(columns).map(this::getColumn).toArray(Column[]::new));
        }

        public OrderByChain add(String column, String ... columns) {
            return this.delegate.add(column, columns);
        }
    }

    protected static class AliasAsserter<S extends Selectable>
    implements Function<S, String> {
        private final Function<S, String> delegate;

        protected AliasAsserter(Function<S, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(S selectable) {
            String alias = this.delegate.apply(selectable);
            if (alias == null) {
                throw new IllegalArgumentException("Item " + selectable.getExpression() + " must have an alias");
            }
            return alias;
        }
    }
}

