/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.AccessorDefinitionDefiner;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByField;
import org.codefilarete.reflection.MutatorByMember;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class PropertyAccessorResolver<C, O> {
    private final PropertyMapping<C, O> propertyMapping;

    public PropertyAccessorResolver(PropertyMapping<C, O> propertyMapping) {
        this.propertyMapping = propertyMapping;
    }

    public ReversibleAccessor<C, O> resolve() {
        AccessorByField accessor = null;
        MutatorByField mutator = null;
        AccessorDefinition accessorDefinition = null;
        if (this.propertyMapping.getGetter() != null) {
            MutatorByField propertySetter;
            AccessorByField getterAsMethodReferenceAccessor;
            accessor = getterAsMethodReferenceAccessor = Accessors.accessorByMethodReference(this.propertyMapping.getGetter());
            if (this.propertyMapping.getField() != null) {
                propertySetter = new MutatorByField(this.propertyMapping.getField());
                accessorDefinition = new AccessorDefinition(getterAsMethodReferenceAccessor.getDeclaringClass(), getterAsMethodReferenceAccessor.getMethodName(), getterAsMethodReferenceAccessor.getPropertyType());
            } else {
                propertySetter = this.resolveMutator((AccessorByMethodReference<C, O>)getterAsMethodReferenceAccessor);
            }
            mutator = propertySetter;
        } else if (this.propertyMapping.getSetter() != null) {
            AccessorByField propertyGetter;
            MutatorByField setterAsMethodReferenceMutator;
            mutator = setterAsMethodReferenceMutator = Accessors.mutatorByMethodReference(this.propertyMapping.getSetter());
            if (this.propertyMapping.getField() != null) {
                propertyGetter = new AccessorByField(this.propertyMapping.getField());
                accessorDefinition = new AccessorDefinition(setterAsMethodReferenceMutator.getDeclaringClass(), setterAsMethodReferenceMutator.getMethodName(), setterAsMethodReferenceMutator.getPropertyType());
            } else {
                propertyGetter = this.resolveAccessor((MutatorByMethodReference<C, O>)setterAsMethodReferenceMutator);
            }
            accessor = propertyGetter;
        }
        if (accessorDefinition != null) {
            return new DefinedPropertyAccessor(accessor, mutator, accessorDefinition);
        }
        return new PropertyAccessor((Accessor)accessor, (Mutator)mutator);
    }

    private MutatorByMember<C, O, ?> resolveMutator(AccessorByMethodReference<C, O> getterAsMethodReferenceAccessor) {
        AccessorDefinition accessorDefinition;
        try {
            accessorDefinition = AccessorDefinition.giveDefinition(getterAsMethodReferenceAccessor);
        }
        catch (Reflections.MemberNotFoundException memberNotFoundException) {
            throw new MappingConfigurationException("Can't find a property matching getter name " + getterAsMethodReferenceAccessor.getMethodName() + ", setter can't be deduced, provide a field name to fix it", memberNotFoundException);
        }
        String capitalizedProperty = Strings.capitalize((CharSequence)accessorDefinition.getName());
        String methodPrefix = Boolean.TYPE.equals(accessorDefinition.getMemberType()) || Boolean.class.equals((Object)accessorDefinition.getMemberType()) ? "is" : "set";
        Method method = Reflections.findMethod((Class)accessorDefinition.getDeclaringClass(), (String)(methodPrefix + capitalizedProperty), (Class[])new Class[]{accessorDefinition.getMemberType()});
        if (method != null) {
            return new MutatorByMethod(method);
        }
        return new MutatorByField(Reflections.getField((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName()));
    }

    private AccessorByMember<C, O, ?> resolveAccessor(MutatorByMethodReference<C, O> setterAsMethodReferenceMutator) {
        AccessorDefinition accessorDefinition;
        try {
            accessorDefinition = AccessorDefinition.giveDefinition(setterAsMethodReferenceMutator);
        }
        catch (Reflections.MemberNotFoundException memberNotFoundException) {
            throw new MappingConfigurationException("Can't find a property matching setter name " + setterAsMethodReferenceMutator.getMethodName() + ", getter can't be deduced, provide a field name to fix it", memberNotFoundException);
        }
        String capitalizedProperty = Strings.capitalize((CharSequence)accessorDefinition.getName());
        String methodPrefix = Boolean.TYPE.equals(accessorDefinition.getMemberType()) || Boolean.class.equals((Object)accessorDefinition.getMemberType()) ? "is" : "get";
        Method method = Reflections.findMethod((Class)accessorDefinition.getDeclaringClass(), (String)(methodPrefix + capitalizedProperty), (Class[])new Class[0]);
        if (method != null) {
            return new AccessorByMethod(method);
        }
        return new AccessorByField(Reflections.getField((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName()));
    }

    private static class DefinedPropertyAccessor<C, T>
    extends PropertyAccessor<C, T>
    implements AccessorDefinitionDefiner<C> {
        private final AccessorDefinition accessorDefinition;

        public DefinedPropertyAccessor(Accessor<C, T> accessor, Mutator<C, T> mutator, AccessorDefinition accessorDefinition) {
            super(accessor, mutator);
            this.accessorDefinition = accessorDefinition;
        }

        public AccessorDefinition asAccessorDefinition() {
            return this.accessorDefinition;
        }

        public Accessor<C, T> toAccessor() {
            return this;
        }

        public Mutator<C, T> toMutator() {
            return this;
        }
    }

    public static interface PropertyMapping<C, O> {
        public SerializableFunction<C, O> getGetter();

        public SerializableBiConsumer<C, O> getSetter();

        public Field getField();
    }
}

