/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.sql.ConnectionWrapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class CurrentThreadConnectionProviderTest {
    CurrentThreadConnectionProviderTest() {
    }

    @Test
    void giveConnection_connectionAutoCommitIsFalse() throws SQLException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenReturn((Object)connectionMock);
        CurrentThreadConnectionProvider testInstance = new CurrentThreadConnectionProvider(dataSourceMock);
        testInstance.giveConnection();
        ((Connection)Mockito.verify((Object)connectionMock)).setAutoCommit(false);
    }

    @Test
    void giveConnection_callTwice_returnSameConnection() throws SQLException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenReturn(Mockito.mock(Connection.class));
        CurrentThreadConnectionProvider testInstance = new CurrentThreadConnectionProvider(dataSourceMock);
        Connection givenConnection1 = testInstance.giveConnection();
        Connection givenConnection2 = testInstance.giveConnection();
        ((DataSource)Mockito.verify((Object)dataSourceMock, (VerificationMode)Mockito.times((int)1))).getConnection();
        Assertions.assertThat((Object)givenConnection1).isSameAs((Object)givenConnection2);
    }

    @Test
    void giveConnection_previousConnectionIsClosed_giveANewOne() throws SQLException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenAnswer((Answer)new CloseableConnection(4));
        CurrentThreadConnectionProvider testInstance = new CurrentThreadConnectionProvider(dataSourceMock, 20);
        Connection givenConnection = testInstance.giveConnection();
        Assertions.assertThat((boolean)givenConnection.isClosed()).isFalse();
        ((DataSource)Mockito.verify((Object)dataSourceMock, (VerificationMode)Mockito.times((int)5))).getConnection();
    }

    @Test
    void giveConnection_2ThreadsAskForAConnection_2DifferentOneAreGiven() throws SQLException, InterruptedException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenAnswer(invocation -> (Connection)Mockito.mock(Connection.class));
        CurrentThreadConnectionProvider testInstance = new CurrentThreadConnectionProvider(dataSourceMock);
        Connection connection = testInstance.giveConnection();
        Hanger.Holder connectionHolder = new Hanger.Holder();
        Thread thread = new Thread(() -> connectionHolder.set((Object)testInstance.giveConnection()));
        thread.start();
        thread.join(200L);
        ((DataSource)Mockito.verify((Object)dataSourceMock, (VerificationMode)Mockito.times((int)2))).getConnection();
        Assertions.assertThat((Object)connection).isNotSameAs(connectionHolder.get());
        if (connection instanceof ConnectionWrapper) {
            Assertions.assertThat((Object)((ConnectionWrapper)connection).getDelegate()).isNotSameAs((Object)((ConnectionWrapper)connectionHolder.get()).getDelegate());
        }
    }

    private static class CloseableConnection
    implements Answer<Connection> {
        private final int closedConnectionsCount;
        private int currentClosedConnectionsCount;

        private CloseableConnection(int closedConnectionsCount) {
            this.closedConnectionsCount = closedConnectionsCount;
        }

        public Connection answer(InvocationOnMock invocation) throws Throwable {
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            if (this.currentClosedConnectionsCount < this.closedConnectionsCount) {
                Mockito.when((Object)connectionMock.isClosed()).thenReturn((Object)true);
                ++this.currentClosedConnectionsCount;
            }
            return connectionMock;
        }
    }
}

