/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.spring.repository.query;

import java.util.List;
import java.util.function.BiFunction;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.spring.repository.query.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.sql.spring.repository.query.PartTreeStalactiteQuery;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.support.PageableExecutionUtils;

public class PartialResultPartTreeStalactiteQuery<C, R extends Slice<C>>
implements RepositoryQuery {
    private final PartTreeStalactiteQuery<C, List<C>> delegate;
    private final BiFunction<StalactiteParametersParameterAccessor, List<C>, R> queryResultAdapter;

    public PartialResultPartTreeStalactiteQuery(QueryMethod method, EntityPersister<C, ?> entityPersister, PartTree tree) {
        this.delegate = new PartTreeStalactiteQuery(method, entityPersister, tree, Accumulators.toList());
        if (method.isSliceQuery()) {
            this.queryResultAdapter = (accessor, result) -> {
                int pageSize = 0;
                Pageable pageable = accessor.getPageable();
                if (pageable.isPaged()) {
                    pageSize = pageable.getPageSize();
                }
                boolean hasNext = pageable.isPaged() && result.size() > pageSize;
                return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, pageable, hasNext);
            };
        } else if (method.isPageQuery()) {
            PartTreeStalactiteProjection countQuery = PartTreeStalactiteProjection.forCount(method, entityPersister, tree);
            this.queryResultAdapter = (accessor, result) -> PageableExecutionUtils.getPage((List)result, (Pageable)accessor.getPageable(), () -> (Long)countQuery.execute(accessor.getValues()));
        } else {
            throw new IllegalArgumentException("Query is not pageable " + method);
        }
    }

    public R execute(Object[] parameters) {
        StalactiteParametersParameterAccessor accessor = new StalactiteParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.delegate.getQueryMethod().isSliceQuery() && accessor.getPageable().getPageNumber() == 0) {
            this.delegate.query.executableEntityQuery.limit(accessor.getPageable().getPageSize() + 1);
        } else {
            this.delegate.query.executableEntityQuery.limit(accessor.getPageable().getPageSize(), Integer.valueOf((int)accessor.getPageable().getOffset()));
        }
        List<C> result = this.delegate.execute(parameters);
        return (R)((Slice)this.queryResultAdapter.apply(accessor, result));
    }

    public QueryMethod getQueryMethod() {
        return this.delegate.getQueryMethod();
    }

    public static class StalactiteParametersParameterAccessor
    extends ParametersParameterAccessor {
        public StalactiteParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values) {
            super(parameters, values);
        }

        public Object[] getValues() {
            return super.getValues();
        }
    }
}

