/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.ZonedDateTimeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ZonedDateTimeMappingTest {
    private static Table targetTable;
    private static Column<Table, LocalDateTime> colA;
    private static Column<Table, ZoneId> colB;
    private ZonedDateTimeMapping testInstance;

    ZonedDateTimeMappingTest() {
    }

    @BeforeAll
    public static void setUpClass() {
        targetTable = new Table("Toto");
        colA = targetTable.addColumn("a", LocalDateTime.class);
        colB = targetTable.addColumn("b", ZoneId.class);
    }

    @BeforeEach
    public void setUp() {
        this.testInstance = new ZonedDateTimeMapping(colA, colB);
    }

    @Test
    void getInsertValue() {
        ZonedDateTime toBePersisted = ZonedDateTime.of(2018, Month.MAY.ordinal(), 16, 17, 53, 44, 0, ZoneId.of("America/Guadeloupe"));
        Map insertValues = this.testInstance.getInsertValues(toBePersisted);
        Assertions.assertThat((Map)insertValues).isEqualTo((Object)Maps.forHashMap(Column.class, Object.class).add(colA, (Object)toBePersisted.toLocalDateTime()).add(colB, (Object)toBePersisted.getZone()));
    }

    @Test
    void transform() {
        ZonedDateTime toBePersisted = ZonedDateTime.of(2018, Month.MAY.ordinal(), 16, 17, 53, 44, 0, ZoneId.of("America/Guadeloupe"));
        Row row = new Row().add(colA.getName(), (Object)toBePersisted.toLocalDateTime()).add(colB.getName(), (Object)toBePersisted.getZone());
        ZonedDateTime hydratedZonedDateTime = this.testInstance.transform(row);
        Assertions.assertThat((ZonedDateTime)toBePersisted).isEqualTo((Object)hydratedZonedDateTime);
    }

    @Test
    void transform_null() {
        Row row = new Row().add(colA.getName(), null).add(colB.getName(), null);
        ZonedDateTime hydratedZonedDateTime = this.testInstance.transform(row);
        Assertions.assertThat((ZonedDateTime)hydratedZonedDateTime).isNull();
    }

    @Test
    void getUpdateValues() {
        ZonedDateTime hydratedZonedDateTime = ZonedDateTime.of(2018, Month.MAY.ordinal(), 16, 17, 53, 44, 0, ZoneId.of("America/Guadeloupe"));
        ZonedDateTime modifiedZonedDateTime = hydratedZonedDateTime.minusHours(4L);
        Map updateValues = this.testInstance.getUpdateValues(modifiedZonedDateTime, hydratedZonedDateTime, false);
        Assertions.assertThat((Map)updateValues).isEqualTo((Object)Maps.asMap((Object)new Mapping.UpwhereColumn(colA, true), (Object)modifiedZonedDateTime.toLocalDateTime()));
        modifiedZonedDateTime = hydratedZonedDateTime.minusHours(4L);
        updateValues = this.testInstance.getUpdateValues(modifiedZonedDateTime, hydratedZonedDateTime, true);
        Assertions.assertThat((Map)updateValues).isEqualTo((Object)Maps.asMap((Object)new Mapping.UpwhereColumn(colA, true), (Object)modifiedZonedDateTime.toLocalDateTime()).add((Object)new Mapping.UpwhereColumn(colB, true), (Object)modifiedZonedDateTime.getZone()));
        modifiedZonedDateTime = hydratedZonedDateTime.withZoneSameLocal(ZoneId.of("Europe/Paris"));
        updateValues = this.testInstance.getUpdateValues(modifiedZonedDateTime, hydratedZonedDateTime, false);
        Assertions.assertThat((Map)updateValues).isEqualTo((Object)Maps.asMap((Object)new Mapping.UpwhereColumn(colB, true), (Object)modifiedZonedDateTime.getZone()));
        modifiedZonedDateTime = hydratedZonedDateTime.withZoneSameInstant(ZoneId.of("Europe/Paris"));
        updateValues = this.testInstance.getUpdateValues(modifiedZonedDateTime, hydratedZonedDateTime, false);
        Assertions.assertThat((Map)updateValues).isEqualTo((Object)Maps.asMap((Object)new Mapping.UpwhereColumn(colA, true), (Object)modifiedZonedDateTime.toLocalDateTime()).add((Object)new Mapping.UpwhereColumn(colB, true), (Object)modifiedZonedDateTime.getZone()));
        updateValues = this.testInstance.getUpdateValues(null, hydratedZonedDateTime, true);
        Assertions.assertThat((Map)updateValues).isEqualTo((Object)Maps.forHashMap(Mapping.UpwhereColumn.class, Object.class).add((Object)new Mapping.UpwhereColumn(colA, true), null).add((Object)new Mapping.UpwhereColumn(colB, true), null));
    }
}

