/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.Lower;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Reflections;

public class OperatorSQLBuilderFactory {
    public OperatorSQLBuilder operatorSQLBuilder() {
        return new OperatorSQLBuilder();
    }

    public static class OperatorSQLBuilder {
        public void cat(ConditionalOperator operator, SQLAppender sql) {
            if (operator instanceof TupleIn) {
                this.catTupledIn((TupleIn)operator, sql);
            } else {
                this.cat(null, operator, sql);
            }
        }

        public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
            if (operator.isNull()) {
                this.catNullValue(operator.isNot(), sql);
            } else if (operator instanceof Equals) {
                this.catEquals((Equals)operator, sql, column);
            } else if (operator instanceof Lower) {
                this.catLower((Lower)operator, sql, column);
            } else if (operator instanceof Greater) {
                this.catGreater((Greater)operator, sql, column);
            } else if (operator instanceof Between) {
                this.catBetween((Between)operator, sql, column);
            } else if (operator instanceof In) {
                this.catIn((In)operator, sql, column);
            } else if (operator instanceof Like) {
                this.catLike((Like)operator, sql, column);
            } else if (operator instanceof IsNull) {
                this.catIsNull((IsNull)operator, sql);
            } else {
                throw new UnsupportedOperationException("Operator " + Reflections.toString(operator.getClass()) + " is not implemented");
            }
        }

        void catNullValue(boolean not, SQLAppender sql) {
            sql.cat("is", new String[0]).catIf(not, " not").cat(" null", new String[0]);
        }

        void catIsNull(IsNull isNull, SQLAppender sql) {
            this.catNullValue(isNull.isNot(), sql);
        }

        void catLike(Like like, SQLAppender sql, Selectable<CharSequence> column) {
            String value = (String)like.getValue();
            if (like.withLeadingStar()) {
                value = '%' + value;
            }
            if (like.withEndingStar()) {
                value = value + '%';
            }
            sql.catIf(like.isNot(), "not ").cat("like ", new String[0]).catValue(column, value);
        }

        <V> void catIn(In<V> in, SQLAppender sql, Selectable<V> column) {
            Iterable<V> value = in.getValue();
            sql.catIf(in.isNot(), "not ").cat("in (", new String[0]);
            this.catInValue(value, sql, column);
            sql.cat(")", new String[0]);
        }

        void catTupledIn(TupleIn in, SQLAppender sql) {
            Column[] columns = in.getColumns();
            List<Object[]> values = in.getValue();
            sql.catIf(in.isNot(), "not ");
            sql.cat("(", new String[0]);
            Iterator columnIterator = Arrays.stream(columns).iterator();
            while (columnIterator.hasNext()) {
                sql.catColumn((Column)columnIterator.next()).catIf(columnIterator.hasNext(), ", ");
            }
            sql.cat(")", new String[0]);
            sql.cat(" in (", new String[0]);
            if (values == null) {
                int columnCount = columns.length;
                for (int i = 0; i < columnCount; ++i) {
                    sql.catValue(columns[i], null).catIf(i < columnCount - 1, ", ");
                }
            } else {
                Iterator valuesIterator = values.iterator();
                while (valuesIterator.hasNext()) {
                    Object[] vals = (Object[])valuesIterator.next();
                    sql.cat("(", new String[0]);
                    int columnCount = columns.length;
                    for (int i = 0; i < columnCount; ++i) {
                        sql.catValue(columns[i], vals[i]).catIf(i < columnCount - 1, ", ");
                    }
                    sql.cat(")", new String[0]).catIf(valuesIterator.hasNext(), ", ");
                }
            }
            sql.cat(")", new String[0]);
        }

        private <V> void catInValue(Iterable<V> value, SQLAppender sql, Selectable<V> column) {
            boolean isFirst = true;
            for (V v : value) {
                if (!isFirst) {
                    sql.cat(", ", new String[0]);
                } else {
                    isFirst = false;
                }
                sql.catValue(column, v);
            }
        }

        <V> void catBetween(Between<V> between, SQLAppender sql, Selectable<V> column) {
            Between.Interval<V> interval = between.getValue();
            if (interval.getValue1() == null) {
                sql.cat(between.isNot() ? ">= " : "< ", new String[0]).catValue(column, interval.getValue2());
            } else if (interval.getValue2() == null) {
                sql.cat(between.isNot() ? "<= " : "> ", new String[0]).catValue(column, interval.getValue1());
            } else {
                sql.catIf(between.isNot(), "not ").cat("between ", new String[0]).catValue(column, interval.getValue1()).cat(" and ", new String[0]).catValue(column, interval.getValue2());
            }
        }

        <V> void catGreater(Greater<V> greater, SQLAppender sql, Selectable<V> column) {
            sql.cat(greater.isNot() ? (greater.isEquals() ? "< " : "<= ") : (greater.isEquals() ? ">= " : "> "), new String[0]).catValue(column, greater.getValue());
        }

        <V> void catLower(Lower<V> lower, SQLAppender sql, Selectable<V> column) {
            sql.cat(lower.isNot() ? (lower.isEquals() ? "> " : ">= ") : (lower.isEquals() ? "<= " : "< "), new String[0]).catValue(column, lower.getValue());
        }

        <V> void catEquals(Equals<V> equals, SQLAppender sql, Selectable<V> column) {
            sql.catIf(equals.isNot(), "!").cat("= ", new String[0]).catValue(column, equals.getValue());
        }
    }
}

