/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordInsertionCascaderTest;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationRecord;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationRecordInsertionCascader;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class IndexedAssociationRecordInsertionCascaderTest {
    IndexedAssociationRecordInsertionCascaderTest() {
    }

    @Test
    void testIndexedAssociationRecordInsertionCascader_getTargets() {
        ClassMapping classMappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)classMappingStrategyMock.getId(ArgumentMatchers.any(AssociationRecordInsertionCascaderTest.Keyboard.class))).thenAnswer(invocation -> ((AssociationRecordInsertionCascaderTest.Keyboard)invocation.getArgument(0)).getId());
        IdMapping idMappingStrategymock = (IdMapping)Mockito.mock(IdMapping.class);
        Mockito.when((Object)idMappingStrategymock.getIdentifierInsertionManager()).thenReturn(Mockito.mock(IdentifierInsertionManager.class));
        Mockito.when((Object)classMappingStrategyMock.getIdMapping()).thenReturn((Object)idMappingStrategymock);
        ClassMapping keyClassMappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)keyClassMappingStrategyMock.getId(ArgumentMatchers.any(AssociationRecordInsertionCascaderTest.Key.class))).thenAnswer(invocation -> ((AssociationRecordInsertionCascaderTest.Key)invocation.getArgument(0)).getId());
        AssociationRecordPersister persisterStub = new AssociationRecordPersister(classMappingStrategyMock, new Dialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 1));
        IndexedAssociationRecordInsertionCascader testInstance = new IndexedAssociationRecordInsertionCascader(persisterStub, AssociationRecordInsertionCascaderTest.Keyboard::getKeys, (EntityMapping)classMappingStrategyMock, (EntityMapping)keyClassMappingStrategyMock);
        AssociationRecordInsertionCascaderTest.Keyboard inputData = new AssociationRecordInsertionCascaderTest.Keyboard(1L);
        AssociationRecordInsertionCascaderTest.Key key1 = new AssociationRecordInsertionCascaderTest.Key(1L);
        AssociationRecordInsertionCascaderTest.Key key2 = new AssociationRecordInsertionCascaderTest.Key(2L);
        AssociationRecordInsertionCascaderTest.Key key3 = new AssociationRecordInsertionCascaderTest.Key(3L);
        inputData.getKeys().addAll(Arrays.asList((Object[])new AssociationRecordInsertionCascaderTest.Key[]{key1, key2, key2, key3}));
        Collection targets = testInstance.getTargets((Object)inputData);
        List expectedResult = Arrays.asList((Object[])new IndexedAssociationRecord[]{new IndexedAssociationRecord(inputData.getId(), key1.getId(), 1), new IndexedAssociationRecord(inputData.getId(), key2.getId(), 2), new IndexedAssociationRecord(inputData.getId(), key2.getId(), 3), new IndexedAssociationRecord(inputData.getId(), key3.getId(), 4)});
        Assertions.assertThat((String)IndexedAssociationRecordInsertionCascaderTest.printIndexedAssociationRecord(targets)).isEqualTo(IndexedAssociationRecordInsertionCascaderTest.printIndexedAssociationRecord(expectedResult));
    }

    private static String printIndexedAssociationRecord(Iterable<IndexedAssociationRecord> records) {
        StringAppender result = new StringAppender(){

            public StringAppender cat(Object o) {
                if (o instanceof IndexedAssociationRecord) {
                    return super.cat((Object)IndexedAssociationRecordInsertionCascaderTest.print((IndexedAssociationRecord)o));
                }
                return super.cat(o);
            }
        };
        result.ccat(records, (Object)", ");
        return result.toString();
    }

    private static String print(IndexedAssociationRecord record) {
        return "{" + record.getLeft() + ", " + record.getIndex() + ", " + record.getRight() + "}";
    }
}

