/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Comparator;
import java.util.TreeSet;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.runtime.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.id.StatefulIdentifier;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.junit.jupiter.api.Test;

class EntityQueryCriteriaSupportTest {
    EntityQueryCriteriaSupportTest() {
    }

    @Test
    void buildComparator_singleDirectProperty() {
        KeepOrderSet orderBy = new KeepOrderSet((Object[])new Duo[]{new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(Country::getName)}), (Object)EntityPersister.OrderByChain.Order.DESC)});
        Comparator objectComparator = EntityQueryCriteriaSupport.buildComparator((KeepOrderSet)orderBy);
        Country country1 = new Country(1L);
        country1.setName("A");
        Country country2 = new Country(2L);
        country2.setName("B");
        Country country3 = new Country(3L);
        country3.setName("C");
        TreeSet objects = new TreeSet(objectComparator);
        objects.addAll(Arrays.asHashSet((Object[])new Country[]{country2, country3, country1}));
        Assertions.assertThat(objects).containsExactly((Object[])new Country[]{country3, country2, country1});
    }

    @Test
    void buildComparator_severalDirectProperty() {
        KeepOrderSet orderBy = new KeepOrderSet((Object[])new Duo[]{new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(Country::getName)}), (Object)EntityPersister.OrderByChain.Order.DESC), new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(Country::getDescription)}), (Object)EntityPersister.OrderByChain.Order.ASC)});
        Comparator objectComparator = EntityQueryCriteriaSupport.buildComparator((KeepOrderSet)orderBy);
        Country country1 = new Country(1L);
        country1.setName("A");
        country1.setDescription("A");
        Country country2 = new Country(2L);
        country2.setName("B");
        country2.setDescription("B");
        Country country3 = new Country(3L);
        country3.setName("C");
        country3.setDescription("C");
        Country country4 = new Country(4L);
        country4.setName("A");
        country4.setDescription("B");
        TreeSet objects = new TreeSet(objectComparator);
        objects.addAll(Arrays.asHashSet((Object[])new Country[]{country2, country3, country1, country4}));
        Assertions.assertThat(objects).containsExactly((Object[])new Country[]{country3, country2, country1, country4});
    }

    @Test
    void buildComparator_severalCombinedProperty() {
        KeepOrderSet orderBy = new KeepOrderSet((Object[])new Duo[]{new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(Country::getName)}), (Object)EntityPersister.OrderByChain.Order.DESC), new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(Country::getId), new AccessorByMethodReference(StatefulIdentifier::getSurrogate)}), (Object)EntityPersister.OrderByChain.Order.ASC)});
        Comparator objectComparator = EntityQueryCriteriaSupport.buildComparator((KeepOrderSet)orderBy);
        Country country1 = new Country(1L);
        country1.setName("A");
        Country country2 = new Country(2L);
        country2.setName("B");
        Country country3 = new Country(3L);
        country3.setName("C");
        Country country4 = new Country(4L);
        country4.setName("A");
        TreeSet objects = new TreeSet(objectComparator);
        objects.addAll(Arrays.asHashSet((Object[])new Country[]{country2, country3, country1, country4}));
        Assertions.assertThat(objects).containsExactly((Object[])new Country[]{country3, country2, country1, country4});
    }

    @Test
    void buildComparator_severalCombinedSetter() {
        KeepOrderSet orderBy = new KeepOrderSet((Object[])new Duo[]{new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(Country::setName)}), (Object)EntityPersister.OrderByChain.Order.DESC), new Duo((Object)Arrays.asList((Object[])new AbstractReflector[]{new AccessorByMethodReference(Country::getCapital), new MutatorByMethodReference(City::setName)}), (Object)EntityPersister.OrderByChain.Order.ASC)});
        Comparator objectComparator = EntityQueryCriteriaSupport.buildComparator((KeepOrderSet)orderBy);
        Country country1 = new Country(1L);
        country1.setName("A");
        City cityA = new City(1L);
        cityA.setName("A");
        country1.setCapital(cityA);
        Country country2 = new Country(2L);
        country2.setName("B");
        City cityB = new City(2L);
        cityB.setName("B");
        country2.setCapital(cityB);
        Country country3 = new Country(3L);
        country3.setName("C");
        City cityC = new City(3L);
        cityC.setName("C");
        country3.setCapital(cityC);
        Country country4 = new Country(4L);
        country4.setName("A");
        City cityD = new City(4L);
        cityD.setName("D");
        country4.setCapital(cityD);
        TreeSet objects = new TreeSet(objectComparator);
        objects.addAll(Arrays.asHashSet((Object[])new Country[]{country2, country3, country1, country4}));
        Assertions.assertThat(objects).containsExactly((Object[])new Country[]{country3, country2, country1, country4});
    }

    @Test
    void buildComparator_severalCombinedSetter_withNullValue() {
        KeepOrderSet orderBy = new KeepOrderSet((Object[])new Duo[]{new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(Country::setName)}), (Object)EntityPersister.OrderByChain.Order.DESC), new Duo((Object)Arrays.asList((Object[])new AbstractReflector[]{new AccessorByMethodReference(Country::getCapital), new MutatorByMethodReference(City::setName)}), (Object)EntityPersister.OrderByChain.Order.ASC)});
        Comparator objectComparator = EntityQueryCriteriaSupport.buildComparator((KeepOrderSet)orderBy);
        Country country1 = new Country(1L);
        country1.setName("A");
        City cityA = new City(1L);
        cityA.setName("A");
        country1.setCapital(cityA);
        Country country2 = new Country(2L);
        City cityB = new City(2L);
        cityB.setName("B");
        country2.setCapital(cityB);
        Country country3 = new Country(3L);
        country3.setName("C");
        City cityC = new City(3L);
        cityC.setName("C");
        country3.setCapital(cityC);
        Country country4 = new Country(4L);
        country4.setName("A");
        TreeSet objects = new TreeSet(objectComparator);
        objects.addAll(Arrays.asHashSet((Object[])new Country[]{country2, country3, country1, country4}));
        Assertions.assertThat(objects).containsExactly((Object[])new Country[]{country2, country3, country1, country4});
    }
}

