/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityQueryCriteriaSupport<C, I> {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityQueryCriteriaSupport.class);
    private final EntityCriteriaSupport<C> entityCriteriaSupport;
    private final EntitySelector<C, I> entitySelector;
    private final PersisterListenerCollection<C, I> persisterListener;

    EntityQueryCriteriaSupport(EntityCriteriaSupport<C> source, EntitySelector<C, I> entitySelector, PersisterListenerCollection<C, I> persisterListener) {
        this.entityCriteriaSupport = new EntityCriteriaSupport<C>(source);
        this.entitySelector = entitySelector;
        this.persisterListener = persisterListener;
    }

    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> wrapIntoExecutable() {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableEntityQuerySupport querySugarSupport = new ExecutableEntityQuerySupport();
        return (RelationalEntityPersister.ExecutableEntityQueryCriteria)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(this.entityCriteriaSupport, querySugarSupport)).redirect(EntityPersister.OrderByChain.class, querySugarSupport, true).redirect(EntityPersister.LimitAware.class, querySugarSupport, true).redirect(RelationalEntityCriteria.class, this.entityCriteriaSupport, true).redirect(ConfiguredEntityCriteria::getCriteria, this.entityCriteriaSupport::getCriteria).redirect(ConfiguredEntityCriteria::hasCollectionCriteria, this.entityCriteriaSupport::hasCollectionCriteria).build(ConfiguredExecutableEntityQueryCriteria.class);
    }

    private <R> Function<Accumulator<C, Set<C>, R>, R> wrapGraphLoad(EntityCriteriaSupport<C> localCriteriaSupport, ExecutableEntityQuerySupport<C> querySugarSupport) {
        Hanger.Holder orderByAdapter = new Hanger.Holder();
        Supplier<Set> entityLoader = () -> {
            if (querySugarSupport.getLimit() != null && this.entityCriteriaSupport.getRootConfiguration().hasCollectionProperty()) {
                throw new UnsupportedOperationException("Can't limit query when entity graph contains Collection relations");
            }
            return this.persisterListener.doWithSelectListener(Collections.emptySet(), () -> this.entitySelector.select(localCriteriaSupport, (Consumer)orderByAdapter.get(), limitAware -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((LimitAware)limitAware).limit(arg_0))));
        };
        return accumulatorParam -> {
            if (localCriteriaSupport.hasCollectionCriteria() && !querySugarSupport.getOrderBy().isEmpty()) {
                orderByAdapter.set(orderByClause -> {});
                LOGGER.debug("Sorting loaded entities in memory");
                Set loadedEntities = (Set)entityLoader.get();
                TreeSet sortedResult = new TreeSet(EntityQueryCriteriaSupport.buildComparator(querySugarSupport.getOrderBy()));
                sortedResult.addAll(loadedEntities);
                return accumulatorParam.collect(sortedResult);
            }
            orderByAdapter.set(orderByClause -> {
                KeepOrderSet<Duo<List<ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy = querySugarSupport.getOrderBy();
                orderBy.forEach(duo -> {
                    Column column = localCriteriaSupport.getRootConfiguration().giveColumn((List)duo.getLeft());
                    orderByClause.add((Selectable)column, duo.getRight() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
                });
            });
            return accumulatorParam.collect((Iterable)entityLoader.get());
        };
    }

    @VisibleForTesting
    static <C> Comparator<C> buildComparator(KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy) {
        List<Duo> orderByAccessors = orderBy.stream().map(duo -> {
            AccessorChain localResult;
            List valueAccessPoints = (List)duo.getLeft();
            if (valueAccessPoints.size() == 1) {
                ValueAccessPoint valueAccessPoint = (ValueAccessPoint)valueAccessPoints.get(0);
                if (valueAccessPoint instanceof Accessor) {
                    localResult = new AccessorChain(new Accessor[]{(Accessor)valueAccessPoint});
                } else {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint);
                    localResult = new AccessorChain(new Accessor[]{Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType())});
                }
            } else {
                localResult = new AccessorChain(valueAccessPoints.stream().map(EntityQueryCriteriaSupport::toAccessor).collect(Collectors.toList()));
            }
            localResult.setNullValueHandler(AccessorChain.RETURN_NULL);
            return new Duo((Object)localResult, duo.getRight());
        }).collect(Collectors.toList());
        Nullable result = Nullable.nullable((Object)null);
        orderByAccessors.forEach(orderByPawn -> {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> ((AccessorChain)((AccessorChain)orderByPawn.getLeft())).get(arg_0), Comparator.nullsLast(Comparator.naturalOrder()));
            if (orderByPawn.getRight() == EntityPersister.OrderByChain.Order.DESC) {
                comparator = comparator.reversed();
            }
            if (result.isPresent()) {
                Comparator<Object> finalComparator = comparator;
                result.map(c -> c.thenComparing(finalComparator));
            } else {
                result.set(comparator);
            }
        });
        return (Comparator)result.get();
    }

    private static <C, T> Accessor<C, T> toAccessor(ValueAccessPoint<C> valueAccessPoint) {
        if (valueAccessPoint instanceof Accessor) {
            return (Accessor)valueAccessPoint;
        }
        if (valueAccessPoint instanceof ReversibleMutator) {
            return ((ReversibleMutator)valueAccessPoint).toAccessor();
        }
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
        AccessorByMember accessor = Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType());
        return accessor;
    }

    private static class ExecutableEntityQuerySupport<C>
    implements EntityPersister.OrderByChain<C, ExecutableEntityQuerySupport<C>>,
    EntityPersister.LimitAware<ExecutableEntityQuerySupport<C>> {
        private Integer limit;
        private final KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy = new KeepOrderSet();

        private ExecutableEntityQuerySupport() {
        }

        public Integer getLimit() {
            return this.limit;
        }

        public KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> getOrderBy() {
            return this.orderBy;
        }

        public ExecutableEntityQuerySupport<C> limit(int count) {
            this.limit = count;
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            AccessorByMethodReference methodReference = new AccessorByMethodReference(getter);
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{methodReference}), (Object)order));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            MutatorByMethodReference methodReference = new MutatorByMethodReference(setter);
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{methodReference}), (Object)order));
            this.assertAccessorIsNotIterable((ValueAccessPoint)methodReference, methodReference.getPropertyType());
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)getter.getAccessors(), (Object)order));
            getter.getAccessors().forEach(accessor -> this.assertAccessorIsNotIterable((ValueAccessPoint)accessor, AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getMemberType()));
            return this;
        }

        private void assertAccessorIsNotIterable(ValueAccessPoint valueAccessPoint, Class memberType) {
            if (Iterable.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : " + (valueAccessPoint instanceof AbstractReflector ? ((AbstractReflector)valueAccessPoint).getDescription() : AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint)).toString());
            }
        }
    }

    private static interface ConfiguredExecutableEntityQueryCriteria<C>
    extends ConfiguredEntityCriteria,
    RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ConfiguredExecutableEntityQueryCriteria<C>> {
    }
}

