/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.cycle;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.cycle.EntityRelationStorage;

class CycleLoadRuntimeContext<SRC, TRGTID> {
    private final Map<String, EntityRelationStorage<SRC, TRGTID>> loadedRelations = new HashMap<String, EntityRelationStorage<SRC, TRGTID>>();

    CycleLoadRuntimeContext() {
    }

    public void addRelationToInitialize(String relationName, SRC src, TRGTID targetId) {
        this.loadedRelations.computeIfAbsent(relationName, k -> new EntityRelationStorage()).addRelationToInitialize(src, targetId);
    }

    public Set<TRGTID> giveIdentifiersToLoad() {
        return this.loadedRelations.values().stream().flatMap(map -> map.getIdentifiersToLoad().stream()).collect(Collectors.toSet());
    }

    public EntityRelationStorage<SRC, TRGTID> getEntitiesToFulFill(String relationName) {
        return this.loadedRelations.get(relationName);
    }
}

