/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SQLParameterParserTest {
    public static Object[][] testParse_data() {
        SQLParameterParser.Parameter paramB = new SQLParameterParser.Parameter("B");
        SQLParameterParser.Parameter paramC = new SQLParameterParser.Parameter("C");
        return new Object[][]{{"select a from Toto where b = 1", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = 1"}), new HashMap())}, {"select a from Toto where b = :B", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB}), (Map)Maps.asMap((Object)"B", (Object)paramB))}, {"select a from Toto where b = :B and c = 1", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = 1"}), (Map)Maps.asMap((Object)"B", (Object)paramB))}, {"select a from Toto where b = :B and c = :C", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = ", paramC}), (Map)Maps.asMap((Object)"B", (Object)paramB).add((Object)"C", (Object)paramC))}, {"select a from Toto where b = 'hello :D !' and c = ':C' and d = :B", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = 'hello :D !' and c = ':C' and d = ", paramB}), (Map)Maps.asMap((Object)"B", (Object)paramB))}, {"select a from Toto where b = \"hello :D !\" and c = \":C\" and d = ':B'", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b = \"hello :D !\" and c = \":C\" and d = ':B'"}), Collections.emptyMap())}};
    }

    @ParameterizedTest
    @MethodSource(value={"testParse_data"})
    public void testParse(String sql, SQLParameterParser.ParsedSQL expectedResult) {
        SQLParameterParser testInstance = new SQLParameterParser(sql);
        SQLParameterParser.ParsedSQL parsedSQL = testInstance.parse();
        Assertions.assertThat((List)parsedSQL.getSqlSnippets()).isEqualTo((Object)expectedResult.getSqlSnippets());
        Assertions.assertThat((Map)parsedSQL.getParametersMap()).isEqualTo((Object)expectedResult.getParametersMap());
    }

    public static Object[][] testParse_inMatcher_data() {
        return new Object[][]{{" in (", true}, {"    in    (   ", true}, {"where in(", true}, {"wherein(", false}, {"in", false}, {" i ( ", false}, {"i(", false}};
    }

    @ParameterizedTest
    @MethodSource(value={"testParse_inMatcher_data"})
    public void testParse_inMatcher(String sql, boolean expectedResult) {
        Matcher matcher = SQLParameterParser.IN_PATTERN.matcher(sql);
        Assertions.assertThat((boolean)matcher.find()).isEqualTo(expectedResult);
    }

    public static Object[][] testParse_in_data() {
        SQLParameterParser.CollectionParameter paramB = new SQLParameterParser.CollectionParameter("B");
        SQLParameterParser.CollectionParameter paramC = new SQLParameterParser.CollectionParameter("C");
        SQLParameterParser.Parameter paramD = new SQLParameterParser.Parameter("D");
        return new Object[][]{{"select a from Toto where b in (:B)", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b in (", paramB, ")"}), (Map)Maps.asMap((Object)"B", (Object)paramB))}, {"select a from Toto where b in (:B) and c in (:C)", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b in (", paramB, ") and c in (", paramC, ")"}), (Map)Maps.asMap((Object)"B", (Object)paramB).add((Object)"C", (Object)paramC))}, {"select a from Toto where b in (:B) and d = :D", new SQLParameterParser.ParsedSQL(Arrays.asList((Object[])new Object[]{"select a from Toto where b in (", paramB, ") and d = ", paramD}), (Map)Maps.asMap((Object)"B", (Object)paramB).add((Object)"D", (Object)paramD))}};
    }

    @ParameterizedTest
    @MethodSource(value={"testParse_in_data"})
    public void testParse_in(String input, SQLParameterParser.ParsedSQL expectedResult) {
        SQLParameterParser testInstance = new SQLParameterParser(input);
        SQLParameterParser.ParsedSQL parsedSQL = testInstance.parse();
        Assertions.assertThat((List)parsedSQL.getSqlSnippets()).isEqualTo((Object)expectedResult.getSqlSnippets());
        Assertions.assertThat((Map)parsedSQL.getParametersMap()).isEqualTo((Object)expectedResult.getParametersMap());
    }

    @Test
    public void testParse_error_causeEmptyParamName() {
        String sql = "select a from Toto where b = :";
        SQLParameterParser testInstance = new SQLParameterParser(sql);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SQLParameterParser)testInstance).parse()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter name can't be empty at position 30");
    }
}

