/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class EntityQueryCriteriaSupport<C, I> {
    private final EntityCriteriaSupport<C> entityCriteriaSupport;
    private final EntitySelector<C, I> entitySelector;
    private final PersisterListenerCollection<C, I> persisterListener;

    EntityQueryCriteriaSupport(EntityCriteriaSupport<C> source, EntitySelector<C, I> entitySelector, PersisterListenerCollection<C, I> persisterListener) {
        this.entityCriteriaSupport = new EntityCriteriaSupport<C>(source);
        this.entitySelector = entitySelector;
        this.persisterListener = persisterListener;
    }

    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C> wrapIntoExecutable() {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableEntityQuerySupport querySugarSupport = new ExecutableEntityQuerySupport();
        return (RelationalEntityPersister.ExecutableEntityQueryCriteria)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(this.entityCriteriaSupport, querySugarSupport)).redirect(EntityPersister.OrderByChain.class, querySugarSupport).redirect(EntityPersister.LimitAware.class, querySugarSupport).redirect(RelationalEntityCriteria.class, this.entityCriteriaSupport, true).redirect(ConfiguredEntityCriteria::getCriteria, this.entityCriteriaSupport::getCriteria).redirect(ConfiguredEntityCriteria::hasCollectionCriteria, this.entityCriteriaSupport::hasCollectionCriteria).build(ConfiguredExecutableEntityQueryCriteria.class);
    }

    private <R> Function<Accumulator<C, Set<C>, R>, R> wrapGraphLoad(EntityCriteriaSupport<C> localCriteriaSupport, ExecutableEntityQuerySupport<C> querySugarSupport) {
        return accumulator -> {
            if (querySugarSupport.getLimit() != null && this.entityCriteriaSupport.getRootConfiguration().hasCollectionProperty()) {
                throw new UnsupportedOperationException("Can't limit query when entity graph contains Collection relations");
            }
            Set result = this.persisterListener.doWithSelectListener(Collections.emptySet(), () -> this.entitySelector.select(localCriteriaSupport, orderByClause -> {
                KeepOrderSet orderBy = querySugarSupport.orderBy;
                orderBy.forEach(duo -> {
                    Column column = localCriteriaSupport.getRootConfiguration().giveColumn((List)duo.getLeft());
                    orderByClause.add(column, duo.getRight() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
                });
            }, limitAware -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((LimitAware)limitAware).limit(arg_0))));
            if (!querySugarSupport.orderBy.isEmpty()) {
                TreeSet<C> sortedResult = new TreeSet<C>(EntityQueryCriteriaSupport.buildComparator(querySugarSupport.orderBy));
                sortedResult.addAll(result);
                return accumulator.collect(sortedResult);
            }
            return accumulator.collect((Iterable)result);
        };
    }

    @VisibleForTesting
    static <C> Comparator<C> buildComparator(KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy) {
        List<Duo> orderByAccessors = orderBy.stream().map(duo -> {
            AccessorChain localResult;
            List valueAccessPoints = (List)duo.getLeft();
            if (valueAccessPoints.size() == 1) {
                ValueAccessPoint valueAccessPoint = (ValueAccessPoint)valueAccessPoints.get(0);
                if (valueAccessPoint instanceof Accessor) {
                    localResult = new AccessorChain(new Accessor[]{(Accessor)valueAccessPoint});
                } else {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint);
                    localResult = new AccessorChain(new Accessor[]{Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType())});
                }
            } else {
                localResult = new AccessorChain(valueAccessPoints.stream().map(EntityQueryCriteriaSupport::toAccessor).collect(Collectors.toList()));
            }
            localResult.setNullValueHandler(AccessorChain.RETURN_NULL);
            return new Duo((Object)localResult, duo.getRight());
        }).collect(Collectors.toList());
        Nullable result = Nullable.nullable((Object)null);
        orderByAccessors.forEach(orderByPawn -> {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> ((AccessorChain)((AccessorChain)orderByPawn.getLeft())).get(arg_0), Comparator.nullsLast(Comparator.naturalOrder()));
            if (orderByPawn.getRight() == EntityPersister.OrderByChain.Order.DESC) {
                comparator = comparator.reversed();
            }
            if (result.isPresent()) {
                Comparator<Object> finalComparator = comparator;
                result.map(c -> c.thenComparing(finalComparator));
            } else {
                result.set(comparator);
            }
        });
        return (Comparator)result.get();
    }

    private static <C, T> Accessor<C, T> toAccessor(ValueAccessPoint<C> valueAccessPoint) {
        if (valueAccessPoint instanceof Accessor) {
            return (Accessor)valueAccessPoint;
        }
        if (valueAccessPoint instanceof ReversibleMutator) {
            return ((ReversibleMutator)valueAccessPoint).toAccessor();
        }
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
        AccessorByMember accessor = Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType());
        return accessor;
    }

    private static class ExecutableEntityQuerySupport<C>
    implements EntityPersister.OrderByChain<C, ExecutableEntityQuerySupport<C>>,
    EntityPersister.LimitAware<ExecutableEntityQuerySupport<C>> {
        private Integer limit;
        private final KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy = new KeepOrderSet();

        private ExecutableEntityQuerySupport() {
        }

        public Integer getLimit() {
            return this.limit;
        }

        public ExecutableEntityQuerySupport<C> limit(int count) {
            this.limit = count;
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), (Object)order));
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), (Object)order));
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)getter.getAccessors(), (Object)order));
            return this;
        }
    }

    private static interface ConfiguredExecutableEntityQueryCriteria<C>
    extends ConfiguredEntityCriteria,
    RelationalEntityPersister.ExecutableEntityQueryCriteria<C> {
    }
}

