/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.InnoDBLockRetryer;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.Retryer;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class MariaDBWriteOperation<ParamType>
extends WriteOperation<ParamType> {
    private final InnoDBLockRetryer retryer;
    private final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider;

    public MariaDBWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener, InnoDBLockRetryer retryer, ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider) {
        super(sqlGenerator, connectionProvider, rowCountListener);
        this.retryer = retryer;
        this.statementProvider = statementProvider;
    }

    public MariaDBWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener, InnoDBLockRetryer retryer) {
        this(sqlGenerator, connectionProvider, rowCountListener, retryer, (ThrowingBiFunction<Connection, String, PreparedStatement, SQLException>)((ThrowingBiFunction)Connection::prepareStatement));
    }

    protected void prepareStatement(Connection connection) throws SQLException {
        this.preparedStatement = (PreparedStatement)this.statementProvider.apply((Object)connection, (Object)this.getSQL());
    }

    protected long doExecuteUpdate() throws SQLException {
        try {
            return ((Integer)this.retryer.execute(this.preparedStatement::executeUpdate, this.getSQL())).intValue();
        }
        catch (Retryer.RetryException e) {
            throw new SQLExecutionException(this.getSQL(), (Throwable)e);
        }
    }

    protected long[] doExecuteBatch() throws SQLException {
        int[] updatedRowCounts;
        try {
            updatedRowCounts = (int[])this.retryer.execute(this.preparedStatement::executeBatch, this.getSQL());
        }
        catch (Retryer.RetryException e) {
            throw new SQLExecutionException(this.getSQL(), (Throwable)e);
        }
        long[] updatedRowCountsAsLong = new long[updatedRowCounts.length];
        for (int i = 0; i < updatedRowCounts.length; ++i) {
            updatedRowCountsAsLong[i] = updatedRowCounts[i];
        }
        return updatedRowCountsAsLong;
    }
}

