/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.collection.ReadOnlyList;

public class JoinRoot<C, I, T extends Fromable>
implements JoinNode<T> {
    private final EntityJoinTree<C, I> tree;
    private final EntityInflater<C, I> entityInflater;
    private final T table;
    private final List<AbstractJoinNode> joins = new ArrayList<AbstractJoinNode>();
    @Nullable
    private String tableAlias;
    @Nullable
    private EntityTreeJoinNodeConsumptionListener<C> consumptionListener;

    public JoinRoot(EntityJoinTree<C, I> tree, EntityInflater<C, I> entityInflater, T table) {
        this.tree = tree;
        this.entityInflater = entityInflater;
        this.table = table;
    }

    public EntityInflater<C, I> getEntityInflater() {
        return this.entityInflater;
    }

    @Nullable
    EntityTreeJoinNodeConsumptionListener<C> getConsumptionListener() {
        return this.consumptionListener;
    }

    public void setConsumptionListener(@Nullable EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
        this.consumptionListener = consumptionListener;
    }

    @Override
    public EntityJoinTree<C, I> getTree() {
        return this.tree;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.entityInflater.getSelectableColumns();
    }

    @Override
    public ReadOnlyList<AbstractJoinNode> getJoins() {
        return new ReadOnlyList(this.joins);
    }

    @Override
    public void add(AbstractJoinNode node) {
        this.joins.add(node);
    }

    @Override
    @Nullable
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(ColumnedRow columnedRow) {
        return new JoinRootRowConsumer<C, I>(this.entityInflater, columnedRow);
    }

    static class JoinRootRowConsumer<C, I>
    implements JoinRowConsumer.RootJoinRowConsumer<C> {
        private final Class<C> entityType;
        private final BiFunction<Row, ColumnedRow, I> identifierDecoder;
        private final RowTransformer<C> entityBuilder;
        private final ColumnedRow columnedRow;

        JoinRootRowConsumer(EntityInflater<C, I> entityInflater, ColumnedRow columnedRow) {
            this.entityType = entityInflater.getEntityType();
            this.identifierDecoder = entityInflater::giveIdentifier;
            this.entityBuilder = entityInflater.copyTransformerWithAliases(columnedRow);
            this.columnedRow = columnedRow;
        }

        @Override
        public C createRootInstance(Row row, EntityTreeInflater.TreeInflationContext context) {
            I identifier = this.identifierDecoder.apply(row, this.columnedRow);
            if (identifier == null) {
                return null;
            }
            return (C)context.giveEntityFromCache(this.entityType, identifier, () -> this.entityBuilder.transform(row));
        }
    }
}

