/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.AssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.IndexedAssociationRecordMapping;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelationConfigurer;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.engine.runtime.AssociationTable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.IndexedAssociationTable;
import org.codefilarete.stalactite.engine.runtime.onetomany.AbstractOneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithAssociationTableEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedAssociationTableEngine;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

class OneToManyWithAssociationTableConfigurer<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToManyConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> {
    private final AssociationTableNamingStrategy associationTableNamingStrategy;
    private final Dialect dialect;
    private final boolean maintainAssociationOnly;
    private final ConnectionConfiguration connectionConfiguration;
    private AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C, ? extends AssociationRecord, ?> associationTableEngine;

    OneToManyWithAssociationTableConfigurer(OneToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> associationConfiguration, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately, AssociationTableNamingStrategy associationTableNamingStrategy, boolean maintainAssociationOnly, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        super(associationConfiguration, targetPersister, loadSeparately);
        this.associationTableNamingStrategy = associationTableNamingStrategy;
        this.dialect = dialect;
        this.maintainAssociationOnly = maintainAssociationOnly;
        this.connectionConfiguration = connectionConfiguration;
    }

    @Override
    protected void configure() {
        this.prepare();
        this.associationTableEngine.addSelectCascade(this.associationConfiguration.getSrcPersister(), this.loadSeparately);
        this.addWriteCascades(this.associationTableEngine);
    }

    private void prepare() {
        PrimaryKey rightPrimaryKey = this.targetPersister.getMapping().getTargetTable().getPrimaryKey();
        String associationTableName = this.associationTableNamingStrategy.giveName(this.accessorDefinition, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey);
        if (this.associationConfiguration.getOneToManyRelation().isOrdered()) {
            this.assignEngineForIndexedAssociation(rightPrimaryKey, associationTableName, this.targetPersister);
        } else {
            this.assignEngineForNonIndexedAssociation(rightPrimaryKey, associationTableName, this.targetPersister);
        }
    }

    @Override
    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, OneToManyRelationConfigurer.FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        this.prepare();
        this.associationTableEngine.addSelectCascadeIn2Phases(firstPhaseCycleLoadListener);
        this.addWriteCascades(this.associationTableEngine);
        return new CascadeConfigurationResult<SRC, TRGT>(this.associationTableEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.getSrcPersister());
    }

    private void addWriteCascades(AbstractOneToManyWithAssociationTableEngine<SRC, TRGT, SRCID, TRGTID, C, ? extends AssociationRecord, ? extends AssociationTable> oneToManyWithAssociationTableEngine) {
        if (this.associationConfiguration.isWriteAuthorized()) {
            oneToManyWithAssociationTableEngine.addInsertCascade(this.maintainAssociationOnly);
            oneToManyWithAssociationTableEngine.addUpdateCascade(this.associationConfiguration.isOrphanRemoval(), this.maintainAssociationOnly);
            oneToManyWithAssociationTableEngine.addDeleteCascade(this.associationConfiguration.isOrphanRemoval(), this.dialect);
        }
    }

    private <ASSOCIATIONTABLE extends AssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForNonIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        boolean createOneSideForeignKey = !this.associationConfiguration.getOneToManyRelation().isSourceTablePerClassPolymorphic();
        boolean createManySideForeignKey = !this.associationConfiguration.getOneToManyRelation().isTargetTablePerClassPolymorphic();
        AssociationTable intermediaryTable = new AssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey);
        this.associationConfiguration.getSrcPersister().getMapping().getIdMapping();
        targetPersister.getMapping().getIdMapping();
        AssociationRecordPersister associationPersister = new AssociationRecordPersister(new AssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
        ManyRelationDescriptor manyRelationDescriptor = new ManyRelationDescriptor(arg_0 -> this.associationConfiguration.getCollectionGetter().get(arg_0), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.giveCollectionFactory(), this.associationConfiguration.getOneToManyRelation().getReverseLink());
        this.associationTableEngine = new OneToManyWithAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, associationPersister, this.dialect.getWriteOperationFactory());
    }

    private <ASSOCIATIONTABLE extends IndexedAssociationTable<ASSOCIATIONTABLE, LEFTTABLE, RIGHTTABLE, SRCID, TRGTID>> void assignEngineForIndexedAssociation(PrimaryKey<RIGHTTABLE, TRGTID> rightPrimaryKey, String associationTableName, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        boolean createOneSideForeignKey = !this.associationConfiguration.getOneToManyRelation().isSourceTablePerClassPolymorphic();
        boolean createManySideForeignKey = !this.associationConfiguration.getOneToManyRelation().isTargetTablePerClassPolymorphic();
        IndexedAssociationTable intermediaryTable = new IndexedAssociationTable(this.associationConfiguration.getLeftPrimaryKey().getTable().getSchema(), associationTableName, this.associationConfiguration.getLeftPrimaryKey(), rightPrimaryKey, this.accessorDefinition, this.associationTableNamingStrategy, this.associationConfiguration.getForeignKeyNamingStrategy(), createOneSideForeignKey, createManySideForeignKey, this.associationConfiguration.getOneToManyRelation().getIndexingColumn());
        AssociationRecordPersister indexedAssociationPersister = new AssociationRecordPersister(new IndexedAssociationRecordMapping(intermediaryTable, this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler(), targetPersister.getMapping().getIdMapping().getIdentifierAssembler(), intermediaryTable.getLeftIdentifierColumnMapping(), intermediaryTable.getRightIdentifierColumnMapping()), this.dialect, this.connectionConfiguration);
        ManyRelationDescriptor manyRelationDescriptor = new ManyRelationDescriptor(arg_0 -> this.associationConfiguration.getCollectionGetter().get(arg_0), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.giveCollectionFactory(), this.associationConfiguration.getOneToManyRelation().getReverseLink());
        this.associationTableEngine = new OneToManyWithIndexedAssociationTableEngine(this.associationConfiguration.getSrcPersister(), targetPersister, manyRelationDescriptor, indexedAssociationPersister, intermediaryTable.getIndexColumn(), this.dialect.getWriteOperationFactory());
    }
}

