/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ddl.DDLAppender;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.PreparedUpdate;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.trace.ModifiableInt;

public class DMLGenerator {
    private static final String EQUAL_SQL_PARAMETER_MARK_AND = " = ? and ";
    protected final ParameterBinderIndex<Column, ParameterBinder> columnBinderRegistry;
    protected Sorter<Column> columnSorter;
    protected final DMLNameProvider dmlNameProvider;

    public DMLGenerator(ParameterBinderIndex<Column, ParameterBinder> columnBinderRegistry) {
        this(columnBinderRegistry, NoopSorter.INSTANCE);
    }

    public DMLGenerator(ParameterBinderIndex<Column, ParameterBinder> columnBinderRegistry, Sorter<Column> columnSorter) {
        this(columnBinderRegistry, columnSorter, new DMLNameProvider(Collections.emptyMap()));
    }

    public DMLGenerator(ParameterBinderIndex<Column, ParameterBinder> columnBinderRegistry, Sorter<Column> columnSorter, DMLNameProvider dmlNameProvider) {
        this.columnBinderRegistry = columnBinderRegistry;
        this.setColumnSorter(columnSorter);
        this.dmlNameProvider = dmlNameProvider;
    }

    public ParameterBinderIndex<Column, ParameterBinder> getColumnBinderRegistry() {
        return this.columnBinderRegistry;
    }

    public void setColumnSorter(Sorter<Column> columnSorter) {
        this.columnSorter = (Sorter)Objects.preventNull(columnSorter, (Object)NoopSorter.INSTANCE);
    }

    public void sortColumnsAlphabetically() {
        this.setColumnSorter(CaseSensitiveSorter.INSTANCE);
    }

    public <T extends Table<T>> ColumnParameterizedSQL<T> buildInsert(Iterable<? extends Column<T, Object>> columns) {
        Iterable<Column> sortedColumns = this.sort(columns);
        Object table = ((Column)Iterables.first(sortedColumns)).getTable();
        DDLAppender sqlInsert = new DDLAppender(this.dmlNameProvider, "insert into ", table, "(");
        sqlInsert.ccat(sortedColumns, ", ");
        sqlInsert.cat(") values (");
        HashMap columnToIndex = new HashMap();
        HashMap parameterBinders = new HashMap();
        ModifiableInt positionCounter = new ModifiableInt(1);
        Iterables.stream(sortedColumns).forEach(column -> {
            if (column.isAutoGenerated()) {
                sqlInsert.cat("default");
                columnToIndex.put(column, new int[0]);
            } else {
                sqlInsert.cat("?");
                columnToIndex.put(column, new int[]{positionCounter.getValue()});
                positionCounter.increment();
                parameterBinders.put(column, this.columnBinderRegistry.getBinder(column));
            }
            sqlInsert.cat(", ");
        });
        sqlInsert.cutTail(", ".length()).cat((Object)")");
        return new ColumnParameterizedSQL(sqlInsert.toString(), columnToIndex, parameterBinders);
    }

    public <T extends Table<T>> PreparedUpdate<T> buildUpdate(Iterable<? extends Column<T, Object>> columns, Iterable<? extends Column<T, Object>> where) {
        Mapping.UpwhereColumn upwhereColumn;
        Iterable<Column> sortedColumns = this.sort(columns);
        Object table = ((Column)Iterables.first(sortedColumns)).getTable();
        DDLAppender sqlUpdate = new DDLAppender(this.dmlNameProvider, "update ", table, " set ");
        HashMap upsertIndexes = new HashMap(10);
        HashMap parameterBinders = new HashMap();
        int positionCounter = 1;
        for (Column column : sortedColumns) {
            sqlUpdate.cat(column, " = ?, ");
            upwhereColumn = new Mapping.UpwhereColumn(column, true);
            upsertIndexes.put(upwhereColumn, positionCounter++);
            parameterBinders.put(upwhereColumn, this.columnBinderRegistry.getBinder((Object)column));
        }
        sqlUpdate.cutTail(2).cat((Object)" where ");
        for (Column column : where) {
            sqlUpdate.cat(column, EQUAL_SQL_PARAMETER_MARK_AND);
            upwhereColumn = new Mapping.UpwhereColumn(column, false);
            upsertIndexes.put(upwhereColumn, positionCounter++);
            parameterBinders.put(upwhereColumn, this.columnBinderRegistry.getBinder((Object)column));
        }
        return new PreparedUpdate(sqlUpdate.cutTail(5).toString(), upsertIndexes, parameterBinders);
    }

    public <T extends Table<T>> ColumnParameterizedSQL<T> buildDelete(T table, Iterable<? extends Column<T, Object>> where) {
        DDLAppender sqlDelete = new DDLAppender(this.dmlNameProvider, "delete from ", table);
        sqlDelete.cat(" where ");
        ParameterizedWhere<T> parameterizedWhere = this.appendWhere(sqlDelete, where);
        sqlDelete.cutTail(5);
        return new ColumnParameterizedSQL(sqlDelete.toString(), ((ParameterizedWhere)parameterizedWhere).indexesPerColumn, ((ParameterizedWhere)parameterizedWhere).parameterBinders);
    }

    public <T extends Table<T>> ColumnParameterizedSQL<T> buildDeleteByKey(T table, Collection<Column<T, Object>> keyColumns, int whereValuesCount) {
        DDLAppender sqlDelete = new DDLAppender(this.dmlNameProvider, "delete from ", table, " where ");
        ParameterizedWhere<T> parameterizedWhere = this.appendTupledWhere(sqlDelete, keyColumns, whereValuesCount);
        Map<Column<T, Object>, int[]> columnToIndex = parameterizedWhere.getColumnToIndex();
        Map<Column<T, Object>, ParameterBinder> parameterBinders = parameterizedWhere.getParameterBinders();
        return new ColumnParameterizedSQL<T>(sqlDelete.toString(), columnToIndex, parameterBinders);
    }

    public <T extends Table<T>> ColumnParameterizedSQL<T> buildSelect(T table, Iterable<? extends Column<T, ?>> columns, Iterable<? extends Column<T, Object>> where) {
        Iterable<Column> sortedColumns = this.sort(columns);
        DDLAppender sqlSelect = new DDLAppender(this.dmlNameProvider, "select ");
        sqlSelect.ccat(sortedColumns, ", ");
        sqlSelect.cat(" from ", table, " where ");
        ParameterizedWhere<T> parameterizedWhere = this.appendWhere(sqlSelect, where);
        sqlSelect.cutTail(5);
        return new ColumnParameterizedSQL(sqlSelect.toString(), ((ParameterizedWhere)parameterizedWhere).indexesPerColumn, ((ParameterizedWhere)parameterizedWhere).parameterBinders);
    }

    public <T extends Table<T>> ColumnParameterizedSelect<T> buildSelectByKey(T table, Iterable<? extends Column<T, Object>> columns, Collection<Column<T, Object>> keyColumns, int whereValuesCount) {
        Iterable<Column> sortedColumns = this.sort(columns);
        DDLAppender sqlSelect = new DDLAppender(this.dmlNameProvider, "select ");
        HashMap<String, ParameterBinder> selectParameterBinders = new HashMap<String, ParameterBinder>();
        for (Column column : sortedColumns) {
            sqlSelect.cat(column, ", ");
            selectParameterBinders.put(this.dmlNameProvider.getSimpleName(column), this.columnBinderRegistry.getBinder((Object)column));
        }
        sqlSelect.cutTail(2).cat((Object)" from ", table, (Object)" where ");
        ParameterizedWhere<T> parameterizedWhere = this.appendTupledWhere(sqlSelect, keyColumns, whereValuesCount);
        Map<Column<T, Object>, int[]> columnToIndex = parameterizedWhere.getColumnToIndex();
        Map<Column<T, Object>, ParameterBinder> parameterBinders = parameterizedWhere.getParameterBinders();
        return new ColumnParameterizedSelect<T>(sqlSelect.toString(), columnToIndex, parameterBinders, selectParameterBinders);
    }

    protected Iterable<Column> sort(Iterable<? extends Column> columns) {
        return this.columnSorter.sort(columns);
    }

    private <T extends Table> ParameterizedWhere<T> appendWhere(DDLAppender sql, Iterable<? extends Column<T, Object>> conditionColumns) {
        ParameterizedWhere result = new ParameterizedWhere();
        ModifiableInt positionCounter = new ModifiableInt(1);
        Iterables.stream(conditionColumns).forEach(column -> {
            sql.cat(column, EQUAL_SQL_PARAMETER_MARK_AND);
            result.indexesPerColumn.put(column, new int[]{positionCounter.getValue()});
            positionCounter.increment();
            result.parameterBinders.put(column, this.columnBinderRegistry.getBinder(column));
        });
        return result;
    }

    public <T extends Table> ParameterizedWhere<T> appendTupledWhere(DDLAppender sql, Collection<Column<T, Object>> conditionColumns, int whereValuesCount) {
        ParameterizedWhere result = new ParameterizedWhere();
        boolean isComposedKey = conditionColumns.size() > 1;
        sql.catIf(isComposedKey, new Object[]{"("}).ccat(conditionColumns, (Object)", ").catIf(isComposedKey, new Object[]{")"});
        sql.cat(" in (");
        StringBuilder repeat = Strings.repeat((int)conditionColumns.size(), (CharSequence)"?, ", (String[])new String[]{"?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, "});
        repeat.setLength(repeat.length() - 2);
        String keyMarks = repeat.toString();
        for (int i = 1; i <= whereValuesCount; ++i) {
            sql.catIf(isComposedKey, new Object[]{"("}).cat((Object)keyMarks);
            sql.catIf(isComposedKey, new Object[]{")"}).cat((Object)", ");
            int startKeyMarkIndex = i - 1;
            ModifiableInt pkIndex = new ModifiableInt();
            conditionColumns.forEach(keyColumn -> {
                int pkColumnIndex;
                ((ParameterizedWhere)result).indexesPerColumn.computeIfAbsent(keyColumn, (Function<Column, int[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$2(int org.codefilarete.stalactite.sql.ddl.structure.Column ), (Lorg/codefilarete/stalactite/sql/ddl/structure/Column;)[I)((int)whereValuesCount))[startKeyMarkIndex] = pkColumnIndex = startKeyMarkIndex * conditionColumns.size() + pkIndex.increment();
            });
        }
        conditionColumns.forEach(keyColumn -> result.parameterBinders.put(keyColumn, this.columnBinderRegistry.getBinder(keyColumn)));
        sql.cutTail(2).cat((Object)")");
        return result;
    }

    private static /* synthetic */ int[] lambda$null$2(int whereValuesCount, Column k) {
        return new int[whereValuesCount];
    }

    private static class ColumnNameComparator
    implements Comparator<Column> {
        private static final ColumnNameComparator INSTANCE = new ColumnNameComparator();

        private ColumnNameComparator() {
        }

        @Override
        public int compare(Column o1, Column o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getAbsoluteName(), o2.getAbsoluteName());
        }
    }

    public class ParameterizedWhere<T extends Table> {
        private final Map<Column<T, Object>, int[]> indexesPerColumn = new HashMap<Column<T, Object>, int[]>();
        private final Map<Column<T, Object>, ParameterBinder> parameterBinders = new HashMap<Column<T, Object>, ParameterBinder>();

        public Map<Column<T, Object>, int[]> getColumnToIndex() {
            return this.indexesPerColumn;
        }

        public Map<Column<T, Object>, ParameterBinder> getParameterBinders() {
            return this.parameterBinders;
        }
    }

    public static class CaseSensitiveSorter<C extends Column>
    implements Sorter<C> {
        public static final CaseSensitiveSorter INSTANCE = new CaseSensitiveSorter();

        public Iterable<C> sort(Iterable<? extends C> columns) {
            TreeSet<Column> result = new TreeSet<Column>(ColumnNameComparator.INSTANCE);
            for (Column column : columns) {
                result.add(column);
            }
            return result;
        }
    }

    public static class NoopSorter
    implements Sorter<Column> {
        public static final NoopSorter INSTANCE = new NoopSorter();

        public Iterable<Column> sort(Iterable<? extends Column> columns) {
            return columns;
        }
    }
}

