/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Map;
import java.util.function.Function;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Strings;

public class DMLNameProvider {
    private final Function<Fromable, String> tableAliases;

    public DMLNameProvider(Function<Fromable, String> tableAliases) {
        this.tableAliases = tableAliases;
    }

    public DMLNameProvider(Map<? extends Fromable, String> tableAliases) {
        this(tableAliases::get);
    }

    public String getName(Selectable<?> column) {
        if (column instanceof JoinLink) {
            String tablePrefix = this.getTablePrefix((Fromable)((JoinLink)column).getOwner());
            return tablePrefix + "." + this.getSimpleName(column);
        }
        return this.getSimpleName(column);
    }

    public String getSimpleName(Selectable<?> column) {
        return column.getExpression();
    }

    public String getAlias(Fromable table) {
        return this.tableAliases.apply(table);
    }

    public String getTablePrefix(Fromable table) {
        String tableAlias = this.getAlias(table);
        return Strings.isEmpty((CharSequence)tableAlias) ? this.getName(table) : tableAlias;
    }

    public String getName(Fromable table) {
        if (table instanceof Table) {
            return table.getAbsoluteName();
        }
        return table.getName();
    }
}

