/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.SingleTableRootJoinNode;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTablePolymorphismEntitySelector<C, I, T extends Table<T>, DTYPE>
implements EntitySelector<C, I> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final Map<Class<C>, ConfiguredRelationalPersister<C, I>> persisterPerSubclass;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final EntityJoinTree<C, I> entityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;
    private final EntityJoinTree<C, I> singleLoadEntityJoinTree;

    public SingleTablePolymorphismEntitySelector(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, ConnectionProvider connectionProvider, Dialect dialect) {
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.persisterPerSubclass = persisterPerSubclass;
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.entityJoinTree = mainPersister.getEntityJoinTree();
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister, persisterPerSubclass);
    }

    private SingleLoadEntityJoinTree<C, I, DTYPE> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass) {
        SingleLoadEntityJoinTree<C, I, DTYPE> result = new SingleLoadEntityJoinTree<C, I, DTYPE>(mainPersister, new HashSet<ConfiguredRelationalPersister<C, I>>(persisterPerSubclass.values()), this.discriminatorColumn, this.polymorphismPolicy);
        mainPersister.getEntityJoinTree().projectTo(result, "ROOT");
        return result;
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        if (where.hasCollectionCriteria()) {
            return this.selectIn2Phases(where);
        }
        return this.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        orderByClauseConsumer.accept((OrderByChain<?>)query.orderBy());
        limitAwareConsumer.accept((LimitAware<?>)query.orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where.getCriteria(), entityTreeQuery.getColumnClones());
        EntityTreeInflater<C> inflater = entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, entityTreeQuery.getSelectParameterBinders());
            Set<C> set = inflater.transform(() -> rowIterator, 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private Set<C> selectIn2Phases(ConfiguredEntityCriteria where) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where.getCriteria(), entityTreeQuery.getColumnClones());
        query.getSelectSurrogate().clear();
        PrimaryKey pk = ((Table)this.entityJoinTree.getRoot().getTable()).getPrimaryKey();
        pk.getColumns().forEach(column -> query.select((Selectable)column, column.getAlias()));
        query.select(this.discriminatorColumn, DISCRIMINATOR_ALIAS);
        HashMap<String, ResultSetReader> columnReaders = new HashMap<String, ResultSetReader>();
        Map aliases = query.getAliases();
        aliases.forEach((selectable, s) -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((String)s, (ResultSetReader)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map<Class, Set<I>> idsPerSubclass = this.readIds(sqlQueryBuilder.toPreparedSQL(), columnReaders, columnedRow);
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subClass, subEntityIds) -> result.addAll(this.persisterPerSubclass.get(subClass).select((Iterable)subEntityIds)));
        return result;
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectSurrogate().setDistinct(distinct);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where, entityTreeQuery.getColumnClones());
        selectAdapter.accept(query.getSelectSurrogate());
        Map aliases = query.getAliases();
        ColumnedRow columnedRow = new ColumnedRow(aliases::get);
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), new AliasAsserter(aliases::get), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparedSQL();
        return this.readProjection(preparedSQL, columnReaders, columnedRow, accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<String, ResultSetReader<?>> columnReaders, ColumnedRow columnedRow, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> selectable -> columnedRow.getValue(selectable, row)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<String, ResultSetReader> columnReaders, ColumnedRow columnedRow) {
        try (ReadOperation closeableOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, columnReaders);
            KeepOrderMap result = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$8(columnedRow, (Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$8(ColumnedRow columnedRow, Map result, Row row) {
        Object dtype = row.get(DISCRIMINATOR_ALIAS);
        Object id = this.identifierAssembler.assemble(row, columnedRow);
        result.computeIfAbsent(this.polymorphismPolicy.getClass(dtype), k -> new KeepOrderSet()).add(id);
    }

    private static class SingleLoadEntityJoinTree<C, I, DTYPE>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
            super(self -> new SingleTableRootJoinNode(self, mainPersister, subPersisters, discriminatorColumn, polymorphismPolicy));
        }
    }

    private static class AliasAsserter<S extends Selectable>
    implements Function<S, String> {
        private final Function<S, String> delegate;

        private AliasAsserter(Function<S, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String apply(S selectable) {
            String alias = this.delegate.apply(selectable);
            if (alias == null) {
                throw new IllegalArgumentException("Item " + selectable.getExpression() + " must have an alias");
            }
            return alias;
        }
    }
}

