/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public abstract class AbstractPolymorphismPersister<C, I>
implements ConfiguredRelationalPersister<C, I>,
PolymorphicPersister<C> {
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final EntityCriteriaSupport<C> criteriaSupport;
    protected final EntitySelector<C, I> entitySelectExecutor;

    protected AbstractPolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, EntitySelector<C, I> entitySelectExecutor) {
        this.mainPersister = mainPersister;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.criteriaSupport = new EntityCriteriaSupport(mainPersister.getMapping());
        this.entitySelectExecutor = entitySelectExecutor;
    }

    @Override
    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C> selectWhere() {
        EntityCriteriaSupport<C> localCriteriaSupport = this.newWhere();
        return this.wrapIntoExecutable(localCriteriaSupport);
    }

    private RelationalEntityPersister.ExecutableEntityQueryCriteria<C> wrapIntoExecutable(EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableEntityQuerySupport querySugarSupport = new ExecutableEntityQuerySupport();
        return (RelationalEntityPersister.ExecutableEntityQueryCriteria)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(localCriteriaSupport, querySugarSupport)).redirect(EntityPersister.OrderByChain.class, querySugarSupport).redirect(EntityPersister.LimitAware.class, querySugarSupport).redirect(RelationalEntityCriteria.class, localCriteriaSupport, true).redirect(ConfiguredEntityCriteria::getCriteria, localCriteriaSupport::getCriteria).redirect(ConfiguredEntityCriteria::hasCollectionCriteria, localCriteriaSupport::hasCollectionCriteria).build(ConfiguredExecutableEntityCriteria.class);
    }

    private <R> Function<Accumulator<C, Set<C>, R>, R> wrapGraphLoad(EntityCriteriaSupport<C> localCriteriaSupport, ExecutableEntityQuerySupport<C> querySugarSupport) {
        return accumulator -> {
            if (querySugarSupport.getLimit() != null && this.criteriaSupport.getRootConfiguration().hasCollectionProperty()) {
                throw new UnsupportedOperationException("Can't limit query when entity graph contains Collection relations");
            }
            Set result = this.getPersisterListener().doWithSelectListener(Collections.emptySet(), () -> this.entitySelectExecutor.select(localCriteriaSupport, orderByClause -> {
                KeepOrderSet orderBy = querySugarSupport.orderBy;
                orderBy.forEach(duo -> {
                    Column column = localCriteriaSupport.getRootConfiguration().giveColumn((List)duo.getLeft());
                    orderByClause.add(column, duo.getRight() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
                });
            }, limitAware -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((LimitAware)limitAware).limit(arg_0))));
            if (!querySugarSupport.orderBy.isEmpty()) {
                TreeSet<C> sortedResult = new TreeSet<C>(AbstractPolymorphismPersister.buildComparator(querySugarSupport.orderBy));
                sortedResult.addAll(result);
                return accumulator.collect(sortedResult);
            }
            return accumulator.collect((Iterable)result);
        };
    }

    @VisibleForTesting
    static <C> Comparator<C> buildComparator(KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy) {
        List<Duo> orderByAccessors = orderBy.stream().map(duo -> {
            AccessorChain localResult;
            List valueAccessPoints = (List)duo.getLeft();
            if (valueAccessPoints.size() == 1) {
                ValueAccessPoint valueAccessPoint = (ValueAccessPoint)valueAccessPoints.get(0);
                if (valueAccessPoint instanceof Accessor) {
                    localResult = new AccessorChain(new Accessor[]{(Accessor)valueAccessPoint});
                } else {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint);
                    localResult = new AccessorChain(new Accessor[]{Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType())});
                }
            } else {
                localResult = new AccessorChain(valueAccessPoints.stream().map(AbstractPolymorphismPersister::toAccessor).collect(Collectors.toList()));
            }
            localResult.setNullValueHandler(AccessorChain.RETURN_NULL);
            return new Duo((Object)localResult, duo.getRight());
        }).collect(Collectors.toList());
        Nullable result = Nullable.nullable((Object)null);
        orderByAccessors.forEach(orderByPawn -> {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> ((AccessorChain)((AccessorChain)orderByPawn.getLeft())).get(arg_0), Comparator.nullsLast(Comparator.naturalOrder()));
            if (orderByPawn.getRight() == EntityPersister.OrderByChain.Order.DESC) {
                comparator = comparator.reversed();
            }
            if (result.isPresent()) {
                Comparator<Object> finalComparator = comparator;
                result.map(c -> c.thenComparing(finalComparator));
            } else {
                result.set(comparator);
            }
        });
        return (Comparator)result.get();
    }

    private static <C, T> Accessor<C, T> toAccessor(ValueAccessPoint<C> valueAccessPoint) {
        if (valueAccessPoint instanceof Accessor) {
            return (Accessor)valueAccessPoint;
        }
        if (valueAccessPoint instanceof ReversibleMutator) {
            return ((ReversibleMutator)valueAccessPoint).toAccessor();
        }
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(valueAccessPoint);
        AccessorByMember accessor = Accessors.accessor((Class)accessorDefinition.getDeclaringClass(), (String)accessorDefinition.getName(), (Class)accessorDefinition.getMemberType());
        return accessor;
    }

    private EntityCriteriaSupport<C> newWhere() {
        return new EntityCriteriaSupport<C>(this.criteriaSupport);
    }

    public EntityPersister.ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter) {
        return this.wrapIntoExecutable(selectAdapter, this.newWhere());
    }

    private EntityPersister.ExecutableProjectionQuery<C> wrapIntoExecutable(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableProjectionQuerySupport querySugarSupport = new ExecutableProjectionQuerySupport();
        return (EntityPersister.ExecutableProjectionQuery)methodDispatcher.redirect(ExecutableProjection::execute, this.wrapProjectionLoad(selectAdapter, localCriteriaSupport, querySugarSupport)).redirect(ExecutableProjection::distinct, querySugarSupport::distinct).redirect(EntityPersister.OrderByChain.class, querySugarSupport).redirect(EntityPersister.LimitAware.class, querySugarSupport).redirect(EntityPersister.EntityCriteria.class, localCriteriaSupport, true).build(EntityPersister.ExecutableProjectionQuery.class);
    }

    private <R> Function<Accumulator<? super Function<? extends Selectable, Object>, Object, R>, R> wrapProjectionLoad(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport, ExecutableProjectionQuerySupport<C> querySugarSupport) {
        return accumulator -> this.entitySelectExecutor.selectProjection(selectAdapter, accumulator, (CriteriaChain)localCriteriaSupport.getCriteria(), querySugarSupport.isDistinct(), orderByClause -> {}, limitAware -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((LimitAware)limitAware).limit(arg_0)));
    }

    public Set<C> selectAll() {
        return this.entitySelectExecutor.select(this.newWhere(), fluentOrderByClause -> {}, limitAware -> {});
    }

    public boolean isNew(C entity) {
        return this.mainPersister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.mainPersister.getClassToPersist();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.mainPersister.getEntityJoinTree();
    }

    private static class ExecutableEntityQuerySupport<C>
    implements EntityPersister.OrderByChain<C, ExecutableEntityQuerySupport<C>>,
    EntityPersister.LimitAware<ExecutableEntityQuerySupport<C>> {
        private Integer limit;
        private final KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy = new KeepOrderSet();

        private ExecutableEntityQuerySupport() {
        }

        public Integer getLimit() {
            return this.limit;
        }

        public ExecutableEntityQuerySupport<C> limit(int count) {
            this.limit = count;
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), (Object)order));
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), (Object)order));
            return this;
        }

        public ExecutableEntityQuerySupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)getter.getAccessors(), (Object)order));
            return this;
        }
    }

    private static class ExecutableProjectionQuerySupport<C>
    implements EntityPersister.OrderByChain<C, ExecutableProjectionQuerySupport<C>>,
    EntityPersister.LimitAware<ExecutableProjectionQuerySupport<C>> {
        private boolean distinct;
        private Integer limit;
        private final KeepOrderSet<Duo<List<? extends ValueAccessPoint<?>>, EntityPersister.OrderByChain.Order>> orderBy = new KeepOrderSet();

        private ExecutableProjectionQuerySupport() {
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        void distinct() {
            this.distinct = true;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public ExecutableProjectionQuerySupport<C> limit(int count) {
            this.limit = count;
            return this;
        }

        public ExecutableProjectionQuerySupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), (Object)order));
            return this;
        }

        public ExecutableProjectionQuerySupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), (Object)order));
            return this;
        }

        public ExecutableProjectionQuerySupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new Duo((Object)getter.getAccessors(), (Object)order));
            return this;
        }
    }

    private static interface ConfiguredExecutableEntityCriteria<C>
    extends ConfiguredEntityCriteria,
    RelationalEntityPersister.ExecutableEntityQueryCriteria<C> {
    }
}

