/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.PreparedStatement;
import java.util.Map;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterIndex;

public abstract class ExpandableStatement<ParamType>
extends SQLStatement<ParamType> {
    private final String sql;

    public ExpandableStatement(String sql, Map<? extends ParamType, ? extends PreparedStatementWriter> parameterBinders) {
        super(parameterBinders);
        this.sql = sql;
    }

    public ExpandableStatement(String sql, PreparedStatementWriterIndex<? extends ParamType, ? extends PreparedStatementWriter> parameterBinderProvider) {
        super(parameterBinderProvider);
        this.sql = sql;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    protected void doApplyValue(ParamType paramType, Object value, PreparedStatement statement) {
        PreparedStatementWriter<Object> parameterBinder = this.getParameterBinder(paramType);
        if (parameterBinder == null) {
            throw new SQLStatement.BindingException("Can't find binder for parameter \"" + this.getParameterName(paramType) + "\" of type " + (value == null ? "unknown" : value.getClass().getName()) + " (value = " + value + ") on sql : " + this.getSQL());
        }
        int[] markIndexes = this.getIndexes(paramType);
        if (markIndexes.length > 1 && value instanceof Iterable) {
            int i = 0;
            while (i < markIndexes.length) {
                for (Object v : (Iterable)value) {
                    int markIndex = markIndexes[i];
                    this.doApplyValue(markIndex, v, parameterBinder, statement);
                    ++i;
                }
            }
        } else {
            for (int markIndex : markIndexes) {
                this.doApplyValue(markIndex, value, parameterBinder, statement);
            }
        }
    }

    protected abstract String getParameterName(ParamType var1);

    protected abstract int[] getIndexes(ParamType var1);
}

