/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder.embeddable;

import java.util.Date;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.UniqueConstraintNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableLinkage;
import org.codefilarete.stalactite.engine.configurer.builder.embeddable.EmbeddableMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.embeddable.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.entity.FluentEntityMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DateBinder;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EmbeddableMappingBuilderTest {
    EmbeddableMappingBuilderTest() {
    }

    @Test
    void giveTargetTable() {
        Table expectedResult = new Table("MyOverridingTable");
        Column colorTable = expectedResult.addColumn("myOverridingColumn", Integer.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).override(Color::getRgb, colorTable);
        Table result = EmbeddableMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping());
        Assertions.assertThat((Object)result).isSameAs((Object)expectedResult);
    }

    @Test
    void giveTargetTable_multipleTableFound_throwsException() {
        Table firstTable = new Table("MyOverridingTable");
        Column nameColumn = firstTable.addColumn("myOverridingColumn", String.class);
        Table secondTable = new Table("MyOverridingTable2");
        Column versionColumn = secondTable.addColumn("myOverridingColumn", Integer.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getOwner, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName).map(Person::getVersion)).override(Person::getName, nameColumn).override(Person::getVersion, versionColumn);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EmbeddableMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping())).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Property o.c.s.e.m.Person::getName overrides column with MyOverridingTable.myOverridingColumn but it is not part of main table MyOverridingTable2");
    }

    @Test
    void giveTargetTable_withImportedConfiguration() {
        Table expectedResult = new Table("MyOverridingTable");
        Column nameColumn = expectedResult.addColumn("myOverridingColumn", String.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getOwner, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName)).override(Person::getName, nameColumn);
        Table result = EmbeddableMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping());
        Assertions.assertThat((Object)result).isSameAs((Object)expectedResult);
    }

    @Test
    void ensureColumnBindingInRegistry() {
        EmbeddableMappingBuilder testInstance;
        Table countryTable = new Table("Country");
        Column dummyColumn = countryTable.addColumn("dummyColumn", Set.class);
        EmbeddableMappingBuilder embeddableMappingBuilder = testInstance = new EmbeddableMappingBuilder((EmbeddableMappingConfiguration)new FluentEmbeddableMappingConfigurationSupport(Country.class), countryTable, new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
        embeddableMappingBuilder.getClass();
        EmbeddableMappingBuilder.InternalProcessor internalProcessor = new EmbeddableMappingBuilder.InternalProcessor(embeddableMappingBuilder, false);
        EmbeddableLinkage linkageMock = (EmbeddableLinkage)Mockito.mock(EmbeddableLinkage.class);
        Mockito.when((Object)linkageMock.getAccessor()).thenReturn((Object)Accessors.accessor(Country::getCities));
        Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Set.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> internalProcessor.ensureColumnBindingInRegistry(linkageMock, dummyColumn)).isInstanceOf(Exception.class)).hasMessage("No binder found for property Country::getCities : neither its column nor its type are registered (Country.dummyColumn, type j.u.Set)");
    }

    @Nested
    class InternalProcessor {
        InternalProcessor() {
        }

        @Test
        void addColumnToTable_existingColumnDoesntMatchLinkageType_linkageAsParameterBinder_doesntThrowException() {
            EmbeddableMappingBuilder testInstanceBuilder;
            Table countryTable = new Table("Country");
            Column dummyColumn = countryTable.addColumn("dummyColumnName", String.class);
            EmbeddableMappingBuilder embeddableMappingBuilder = testInstanceBuilder = new EmbeddableMappingBuilder((EmbeddableMappingConfiguration)new FluentEmbeddableMappingConfigurationSupport(Country.class), countryTable, new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
            embeddableMappingBuilder.getClass();
            EmbeddableMappingBuilder.InternalProcessor testInstance = new EmbeddableMappingBuilder.InternalProcessor(embeddableMappingBuilder, false);
            EmbeddableLinkage linkageMock = (EmbeddableLinkage)Mockito.mock(EmbeddableLinkage.class);
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Date.class);
            Mockito.when((Object)linkageMock.getParameterBinder()).thenReturn((Object)new DateBinder(){

                public <O> Class<O> getColumnType() {
                    return String.class;
                }
            });
            Assertions.assertThatCode(() -> testInstance.addColumnToTable(linkageMock, dummyColumn.getName(), dummyColumn.getSize())).doesNotThrowAnyException();
        }

        @Test
        void addColumnToTable_handlePrimitiveTypeAndNullability() {
            EmbeddableMappingBuilder testInstanceBuilder;
            Table countryTable = new Table("Country");
            EmbeddableMappingBuilder embeddableMappingBuilder = testInstanceBuilder = new EmbeddableMappingBuilder((EmbeddableMappingConfiguration)new FluentEmbeddableMappingConfigurationSupport(Country.class), countryTable, new ColumnBinderRegistry(), ColumnNamingStrategy.DEFAULT, UniqueConstraintNamingStrategy.DEFAULT);
            embeddableMappingBuilder.getClass();
            EmbeddableMappingBuilder.InternalProcessor testInstance = new EmbeddableMappingBuilder.InternalProcessor(embeddableMappingBuilder, false);
            EmbeddableLinkage linkageMock = (EmbeddableLinkage)Mockito.mock(EmbeddableLinkage.class);
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Integer.TYPE);
            Mockito.when((Object)linkageMock.isNullable()).thenReturn(null);
            Column intColumn = testInstance.addColumnToTable(linkageMock, "dummyName_int", null);
            Assertions.assertThat((Boolean)intColumn.isNullable()).isFalse();
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Integer.class);
            Column integerColumn = testInstance.addColumnToTable(linkageMock, "dummyName_integer", null);
            Assertions.assertThat((Boolean)integerColumn.isNullable()).isNull();
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Integer.TYPE);
            Mockito.when((Object)linkageMock.isNullable()).thenReturn((Object)true);
            Column intNullableColumn = testInstance.addColumnToTable(linkageMock, "dummyName_int_nullable", null);
            Assertions.assertThat((Boolean)intNullableColumn.isNullable()).isTrue();
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Integer.class);
            Mockito.when((Object)linkageMock.isNullable()).thenReturn((Object)false);
            Column integerNotNullableColumn = testInstance.addColumnToTable(linkageMock, "dummyName_integer_notNullable", null);
            Assertions.assertThat((Boolean)integerNotNullableColumn.isNullable()).isFalse();
        }
    }
}

