/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class QuerySQLBuilderTest {
    private final Dialect dialect = new DefaultDialect();

    QuerySQLBuilderTest() {
    }

    public static Object[][] toSQL() {
        Table tableToto = new Table(null, "Toto");
        Column colTotoA = tableToto.addColumn("a", String.class);
        Column colTotoB = tableToto.addColumn("b", String.class);
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        Query query1 = (Query)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto).getQuery();
        Query query2 = (Query)QueryEase.select((Selectable)colTataA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableTata).getQuery();
        Union union = new Union(new Query[]{query1, query2});
        return new Object[][]{{QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto), "select Toto.a, Toto.b from Toto"}, {((Query.FluentSelectClause)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).distinct()).from((Fromable)tableToto), "select distinct Toto.a, Toto.b from Toto"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "t"), "select t.a, t.b from Toto as t"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB, colTataA, colTataB}).from((Fromable)tableToto, "to").crossJoin((Fromable)tableTata), "select to.a, to.b, Tata.a, Tata.b from Toto as to cross join Tata"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB, colTataA, colTataB}).from((Fromable)tableToto, "to").crossJoin((Fromable)tableTata, "ta"), "select to.a, to.b, ta.a, ta.b from Toto as to cross join Tata as ta"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y"), "select Toto.a, Tata.b from Toto inner join Tata on x = y"}, {((Query.FluentFromClause)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((JoinLink)colTotoA, (JoinLink)colTataB).setAlias((Fromable)colTotoA.getTable(), "toto")).setAlias((Fromable)colTataB.getTable(), "tata"), "select toto.a, tata.b from Toto as toto inner join Tata as tata on toto.a = tata.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)query1.asPseudoTable()), "select Toto.a, Tata.b from (select Toto.a, Toto.b from Toto)"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)query1.asPseudoTable("a")), "select Toto.a, Tata.b from (select Toto.a, Toto.b from Toto) as a"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)union.asPseudoTable()), "select Toto.a, Tata.b from (select Toto.a, Toto.b from Toto union all select Tata.a, Tata.b from Tata)"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)union.asPseudoTable("a")), "select Toto.a, Tata.b from (select Toto.a, Toto.b from Toto union all select Tata.a, Tata.b from Tata) as a"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1"), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").groupBy(colTotoB, new Column[0]), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 group by Toto.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").groupBy(colTotoB, new Column[0]).having(new Object[]{"sum(", colTotoB, ") > 1"}), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 group by Toto.b having sum(Toto.b) > 1"}, {((Query.FluentGroupByClause)((Query.FluentWhereClause)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").and(colTataA, (CharSequence)"= 4")).groupBy(colTotoB, new Column[0]).add(colTataB, new Column[0])).having(new Object[]{"sum(", colTotoB, ") > 1"}).and(new Object[]{"count(id) = 0"}), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 and Tata.a = 4 group by Toto.b, Tata.b having sum(Toto.b) > 1 and count(id) = 0"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy((Selectable)colTotoA, OrderByChain.Order.ASC), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by Toto.a asc"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy((Selectable)colTotoA, OrderByChain.Order.DESC), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by Toto.a desc"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy("titi", OrderByChain.Order.ASC), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by titi asc"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy("titi", OrderByChain.Order.DESC), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by titi desc"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy((Selectable)colTotoA, new Selectable[]{colTataB}), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by Toto.a, Tata.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy((Selectable)colTotoA, new Selectable[]{colTataB}).add("titi", OrderByChain.Order.ASC), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by Toto.a, Tata.b, titi asc"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").orderBy("titi", new String[0]).add((Selectable)colTotoA, new Selectable[]{colTataB}), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 order by titi, Toto.a, Tata.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").groupBy(colTotoB, new Column[0]).orderBy((Selectable)colTotoB, new Selectable[0]), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 group by Toto.b order by Toto.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, (Fromable)tableTata, "x = y").where(colTotoB, (CharSequence)"= 1").groupBy(colTotoB, new Column[0]).having(new Object[]{"sum(", colTotoB, ") > 1"}).orderBy((Selectable)colTotoB, new Selectable[0]), "select Toto.a, Tata.b from Toto inner join Tata on x = y where Toto.b = 1 group by Toto.b having sum(Toto.b) > 1 order by Toto.b"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).limit(2), "select Toto.a, Tata.b from Toto limit 2"}, {((Query.FluentLimitClause)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).limit(2)).unionAll((QueryProvider)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).limit(2)), "select Toto.a, Tata.b from Toto limit 2 union all select Toto.a, Tata.b from Toto limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (CharSequence)"= 1").limit(2), "select Toto.a, Tata.b from Toto where Toto.b = 1 limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (CharSequence)"= 1").orderBy((Selectable)colTotoA, new Selectable[0]).limit(2), "select Toto.a, Tata.b from Toto where Toto.b = 1 order by Toto.a limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (CharSequence)"= 1").groupBy(colTotoA, new Column[0]).limit(2), "select Toto.a, Tata.b from Toto where Toto.b = 1 group by Toto.a limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (CharSequence)"= 1").groupBy(colTotoA, new Column[0]).having(new Object[]{Operators.sum((Selectable)colTotoB), " > 1"}).limit(2), "select Toto.a, Tata.b from Toto where Toto.b = 1 group by Toto.a having sum(Toto.b) > 1 limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T").where(colTotoB, (CharSequence)"= 1").groupBy(colTotoA, new Column[0]).having(new Object[]{Operators.sum((Selectable)colTotoB), " > 1"}).limit(2), "select T.a, Tata.b from Toto as T where T.b = 1 group by T.a having sum(T.b) > 1 limit 2"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T1").where(colTotoB, (CharSequence)"= 1").unionAll((QueryProvider)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T2").where(colTotoB, (CharSequence)"= 1")), "select T1.a, Tata.b from Toto as T1 where T1.b = 1 union all select T2.a, Tata.b from Toto as T2 where T2.b = 1"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "T").innerJoin((QueryProvider)QueryEase.select((Iterable)tableTata.getColumns()).from((Fromable)tableTata, "TATA"), "subTATA", "Toto.a = subTATA.a"), "select T.a, T.b from Toto as T inner join (select TATA.a, TATA.b from Tata as TATA) as subTATA on Toto.a = subTATA.a"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "T").leftOuterJoin((QueryProvider)QueryEase.select((Iterable)tableTata.getColumns()).from((Fromable)tableTata, "TATA"), "subTATA", "Toto.a = subTATA.a"), "select T.a, T.b from Toto as T left outer join (select TATA.a, TATA.b from Tata as TATA) as subTATA on Toto.a = subTATA.a"}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "T").rightOuterJoin((QueryProvider)QueryEase.select((Iterable)tableTata.getColumns()).from((Fromable)tableTata, "TATA"), "subTATA", "Toto.a = subTATA.a"), "select T.a, T.b from Toto as T right outer join (select TATA.a, TATA.b from Tata as TATA) as subTATA on Toto.a = subTATA.a"}};
    }

    @ParameterizedTest
    @MethodSource(value={"toSQL"})
    public void toSQL(QueryProvider<QueryStatement> queryProvider, String expected) {
        QuerySQLBuilderFactory.QueryStatementSQLBuilder testInstance = this.dialect.getQuerySQLBuilderFactory().queryStatementBuilder(queryProvider.getQuery());
        Assertions.assertThat((CharSequence)testInstance.toSQL()).isEqualTo((Object)expected);
    }

    public static Object[][] toPreparableSQL() {
        Table tableToto = new Table(null, "Toto");
        Column colTotoA = tableToto.addColumn("a", String.class);
        Column colTotoB = tableToto.addColumn("b", String.class);
        Table tableTata = new Table(null, "Tata");
        Column colTataA = tableTata.addColumn("a", String.class);
        Column colTataB = tableTata.addColumn("b", String.class);
        TupleIn tupleIn = new TupleIn(new Column[]{colTotoA, colTataB}, Arrays.asList({"John", "Doe"}, {"Jane", null}));
        return new Object[][]{{QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (ConditionalOperator)Operators.eq((Object)1)).groupBy(colTotoA, new Column[0]).having(new Object[]{"sum(", colTotoB, ") ", Operators.gt((Object)1)}).limit(2), "select Toto.a, Tata.b from Toto where Toto.b = ? group by Toto.a having sum(Toto.b) > ? limit ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)1).add((Object)2, (Object)1).add((Object)3, (Object)2)}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).where(colTotoB, (ConditionalOperator)Operators.eq((Object)1)).groupBy(colTotoA, new Column[0]).having(new Object[]{Operators.sum((Selectable)colTotoB), Operators.lt((Object)1)}).limit(2), "select Toto.a, Tata.b from Toto where Toto.b = ? group by Toto.a having sum(Toto.b)< ? limit ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)1).add((Object)2, (Object)1).add((Object)3, (Object)2)}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T").where(colTotoB, (ConditionalOperator)Operators.eq((Object)1)).groupBy(colTotoA, new Column[0]).having(new Object[]{Operators.sum((Selectable)colTotoB), Operators.gt((Object)1)}).limit(2), "select T.a, Tata.b from Toto as T where T.b = ? group by T.a having sum(T.b)> ? limit ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)1).add((Object)2, (Object)1).add((Object)3, (Object)2)}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T").where(new Object[]{tupleIn}).groupBy(colTotoA, new Column[0]).having(new Object[]{Operators.sum((Selectable)colTotoB), Operators.gt((Object)1)}).limit(2), "select T.a, Tata.b from Toto as T where (T.a, Tata.b) in ((?, ?), (?, ?)) group by T.a having sum(T.b)> ? limit ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)"John").add((Object)2, (Object)"Doe").add((Object)3, (Object)"Jane").add((Object)4, null).add((Object)5, (Object)1).add((Object)6, (Object)2)}, {((Query.FluentFromClause)((Query.FluentFromClause)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto).innerJoin((JoinLink)colTotoA, (JoinLink)colTataA)).setAlias((Fromable)tableTata, "x")).where(colTataB, (ConditionalOperator)Operators.eq((Object)1)), "select Toto.a, x.b from Toto inner join Tata as x on Toto.a = x.a where x.b = ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)1)}, {QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T").where(colTotoB, (ConditionalOperator)Operators.eq((Object)11)).unionAll((QueryProvider)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableToto, "T1").where(colTotoB, (ConditionalOperator)Operators.eq((Object)22))), "select T.a, Tata.b from Toto as T where T.b = ? union all select T1.a, Tata.b from Toto as T1 where T1.b = ?", Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)11).add((Object)2, (Object)22)}};
    }

    @ParameterizedTest
    @MethodSource(value={"toPreparableSQL"})
    public void toPreparableSQL(QueryProvider<QueryStatement> queryProvider, String expectedPreparedStatement, Map<Integer, Object> expectedValues) {
        QuerySQLBuilderFactory.QueryStatementSQLBuilder testInstance = this.dialect.getQuerySQLBuilderFactory().queryStatementBuilder(queryProvider.getQuery());
        PreparedSQL preparedSQL = testInstance.toPreparableSQL().toPreparedSQL(new HashMap());
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo(expectedPreparedStatement);
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo(expectedValues);
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class UnionSQLBuilderTest {
        private final Dialect dialect = new DefaultDialect();
        private final QuerySQLBuilderFactory querySQLBuilderFactory = this.dialect.getQuerySQLBuilderFactory();

        UnionSQLBuilderTest() {
        }

        public Object[][] toSQL() {
            Table tableToto = new Table(null, "Toto");
            Column colTotoA = tableToto.addColumn("a", String.class);
            Column colTotoB = tableToto.addColumn("b", String.class);
            Table tableTata = new Table(null, "Tata");
            Column colTataA = tableTata.addColumn("a", String.class);
            Column colTataB = tableTata.addColumn("b", String.class);
            Query query1 = (Query)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto).getQuery();
            Query query2 = (Query)QueryEase.select((Selectable)colTataA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableTata).getQuery();
            Query aliasedQuery1 = (Query)QueryEase.select((Selectable)colTotoA, (Selectable[])new Selectable[]{colTotoB}).from((Fromable)tableToto, "To").getQuery();
            Query aliasedQuery2 = (Query)QueryEase.select((Selectable)colTataA, (Selectable[])new Selectable[]{colTataB}).from((Fromable)tableTata, "Ta").getQuery();
            return new Object[][]{{new Union(new Query[]{query1, query2}), "select Toto.a, Toto.b from Toto union all select Tata.a, Tata.b from Tata"}, {new Union(new Query[]{aliasedQuery1, aliasedQuery2}), "select To.a, To.b from Toto as To union all select Ta.a, Ta.b from Tata as Ta"}};
        }

        @ParameterizedTest
        @MethodSource(value={"toSQL"})
        public void toSQL(Union union, String expected) {
            QuerySQLBuilderFactory.UnionSQLBuilder testInstance = new QuerySQLBuilderFactory.UnionSQLBuilder(union, this.querySQLBuilderFactory);
            Assertions.assertThat((CharSequence)testInstance.toSQL()).isEqualTo((Object)expected);
        }
    }
}

