/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manytomany;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethod;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethod;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

class ManyToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C1 extends Collection<TRGT>, C2 extends Collection<SRC>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
    private final ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation;
    private final ConfiguredRelationalPersister<SRC, SRCID> srcPersister;
    private final PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final ColumnNamingStrategy indexColumnNamingStrategy;
    private final ReversibleAccessor<SRC, C1> collectionGetter;
    private final Mutator<SRC, C1> setter;
    private final boolean orphanRemoval;
    private final boolean writeAuthorized;
    private final AccessorDefinition accessorDefinition;
    private final Supplier<C1> collectionFactory;
    private final MethodReferenceCapturer methodSpy = new MethodReferenceCapturer();

    ManyToManyAssociationConfiguration(ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> manyToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> srcPersister, PrimaryKey<LEFTTABLE, SRCID> leftPrimaryKey, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy, boolean orphanRemoval, boolean writeAuthorized) {
        this.manyToManyRelation = manyToManyRelation;
        this.srcPersister = srcPersister;
        this.leftPrimaryKey = leftPrimaryKey;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.collectionGetter = manyToManyRelation.getCollectionAccessor();
        this.indexColumnNamingStrategy = indexColumnNamingStrategy;
        this.setter = this.collectionGetter.toMutator();
        this.orphanRemoval = orphanRemoval;
        this.writeAuthorized = writeAuthorized;
        this.accessorDefinition = AccessorDefinition.giveDefinition(this.manyToManyRelation.getCollectionAccessor());
        this.collectionFactory = this.buildCollectionFactory();
    }

    private Supplier<C1> buildCollectionFactory() {
        Supplier result = this.manyToManyRelation.getCollectionFactory();
        if (result == null) {
            result = Reflections.giveCollectionFactory((Class)this.accessorDefinition.getMemberType());
        }
        return result;
    }

    public ManyToManyRelation<SRC, TRGT, TRGTID, C1, C2> getManyToManyRelation() {
        return this.manyToManyRelation;
    }

    public ColumnNamingStrategy getIndexColumnNamingStrategy() {
        return this.indexColumnNamingStrategy;
    }

    public ConfiguredRelationalPersister<SRC, SRCID> getSrcPersister() {
        return this.srcPersister;
    }

    public PrimaryKey<LEFTTABLE, SRCID> getLeftPrimaryKey() {
        return this.leftPrimaryKey;
    }

    public ForeignKeyNamingStrategy getForeignKeyNamingStrategy() {
        return this.foreignKeyNamingStrategy;
    }

    public ReversibleAccessor<SRC, C1> getCollectionGetter() {
        return this.collectionGetter;
    }

    public Mutator<SRC, C1> getSetter() {
        return this.setter;
    }

    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    public boolean isWriteAuthorized() {
        return this.writeAuthorized;
    }

    public AccessorDefinition getAccessorDefinition() {
        return this.accessorDefinition;
    }

    protected Supplier<C1> getCollectionFactory() {
        return this.collectionFactory;
    }

    @javax.annotation.Nullable
    PropertyAccessor<TRGT, C2> buildReversePropertyAccessor() {
        ManyToManyRelation.MappedByConfiguration<SRC, TRGT, C2> mappedByConfiguration = this.manyToManyRelation.getMappedByConfiguration();
        Nullable getterReference = Nullable.nullable(mappedByConfiguration.getReverseCollectionAccessor()).map(Accessors::accessorByMethodReference);
        Nullable setterReference = Nullable.nullable(mappedByConfiguration.getReverseCollectionMutator()).map(Accessors::mutatorByMethodReference);
        if (getterReference.isAbsent() && setterReference.isAbsent()) {
            return null;
        }
        if (getterReference.isPresent() && setterReference.isPresent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), (Mutator)setterReference.get());
        }
        if (getterReference.isPresent() && setterReference.isAbsent()) {
            return new PropertyAccessor((Accessor)getterReference.get(), new AccessorByMethod(this.captureMethod(mappedByConfiguration.getReverseCollectionAccessor())).toMutator());
        }
        return new PropertyAccessor(new MutatorByMethod(this.captureMethod(mappedByConfiguration.getReverseCollectionMutator())).toAccessor(), (Mutator)setterReference.get());
    }

    private Method captureMethod(SerializableFunction getter) {
        return this.methodSpy.findMethod(getter);
    }

    private Method captureMethod(SerializableBiConsumer setter) {
        return this.methodSpy.findMethod(setter);
    }
}

