/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.manyToOne;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.builder.PostInitializer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.cycle.ManyToOneCycleLoader;

public class ManyToOneCycleConfigurer<TRGT>
extends PostInitializer<TRGT> {
    private final Set<RelationConfigurer<?, ?, ?>> relations = new LinkedHashSet();
    private final ManyToOneRelation<?, TRGT, ?, ?> manyToOneRelation;

    public ManyToOneCycleConfigurer(Class<TRGT> targetEntityType, ManyToOneRelation<?, TRGT, ?, ?> manyToOneRelation) {
        super(targetEntityType);
        this.manyToOneRelation = manyToOneRelation;
    }

    public <SRC> void addCycleSolver(String relationIdentifier, ManyToOneOwnedBySourceConfigurer<SRC, TRGT, ?, ?, ?, ?, ?> manyToOneRelationConfigurer) {
        this.relations.add(new RelationConfigurer(relationIdentifier, manyToOneRelationConfigurer));
    }

    @Override
    public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
        this.registerRelationLoader(targetPersister);
    }

    private <SRC, TRGTID> void registerRelationLoader(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        ManyToOneCycleLoader manyToOneCycleLoader = new ManyToOneCycleLoader(targetPersister);
        targetPersister.addSelectListener(manyToOneCycleLoader);
        this.relations.forEach(c -> {
            String tableAlias = ((RelationConfigurer)c).relationName.replaceAll("\\W", "_");
            CascadeConfigurationResult configurationResult = ((RelationConfigurer)c).manyToOneRelationConfigurer.configureWithSelectIn2Phases(tableAlias, targetPersister, manyToOneCycleLoader, this.manyToOneRelation.getColumnName());
            manyToOneCycleLoader.addRelation(((RelationConfigurer)c).relationName, configurationResult);
        });
    }

    private class RelationConfigurer<SRC, SRCID, TRGTID> {
        private final String relationName;
        private final ManyToOneOwnedBySourceConfigurer<SRC, TRGT, SRCID, TRGTID, ?, ?, ?> manyToOneRelationConfigurer;

        public RelationConfigurer(String relationName, ManyToOneOwnedBySourceConfigurer<SRC, TRGT, SRCID, TRGTID, ?, ?, ?> manyToOneRelationConfigurer) {
            this.relationName = relationName;
            this.manyToOneRelationConfigurer = manyToOneRelationConfigurer;
        }
    }
}

