/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinTableRootJoinNode<C, I, T extends Table<T>>
extends JoinRoot<C, I, T> {
    private final Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters;
    private final Set<Column<T, ?>> selectableColumns;
    private JoinTablePolymorphicJoinRootRowConsumer<C, I> rootConsumer;

    public JoinTableRootJoinNode(EntityJoinTree<C, I> tree, ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Set<? extends Column<T, ?>> selectableColumns, T mainTable) {
        super(tree, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), mainTable);
        this.subPersisters = subPersisters;
        this.selectableColumns = selectableColumns;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.selectableColumns;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(JoinNode<C, T> joinNode) {
        RowTransformer rootRowTransformer = this.getEntityInflater().getRowTransformer();
        Set subEntityConsumer = this.subPersisters.stream().map(subPersister -> {
            EntityMapping mapping = subPersister.getMapping();
            return new SubPersisterConsumer(row -> mapping.getIdMapping().getIdentifierAssembler().assemble(row), mapping.getClassToPersist(), mapping.getRowTransformer());
        }).collect(Collectors.toSet());
        this.rootConsumer = new JoinTablePolymorphicJoinRootRowConsumer(joinNode, rootRowTransformer, subEntityConsumer, this.getConsumptionListener() == null ? null : (rootEntity, row) -> this.getConsumptionListener().onNodeConsumption(rootEntity, arg_0 -> ((ColumnedRow)EntityTreeInflater.currentContext().getDecoder(joinNode)).get(arg_0)));
        return this.rootConsumer;
    }

    public void addSubPersister(ConfiguredRelationalPersister<C, I> persister, MergeJoinNode.MergeJoinRowConsumer<C> subConsumer) {
        ((JoinTablePolymorphicJoinRootRowConsumer)this.rootConsumer).subConsumers.forEach(pawnConsumer -> {
            if (((SubPersisterConsumer)pawnConsumer).subEntityType == persister.getClassToPersist()) {
                ((SubPersisterConsumer)pawnConsumer).subPropertiesApplier = subConsumer;
                ((SubPersisterConsumer)pawnConsumer).identifierAssembler = row -> persister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row);
            }
        });
    }

    static class JoinTablePolymorphicJoinRootRowConsumer<C, I>
    implements JoinRowConsumer.ExcludingJoinRowConsumer<C> {
        private static final ThreadLocal<MergeJoinNode.MergeJoinRowConsumer<?>> CURRENTLY_FOUND_CONSUMER = new ThreadLocal();
        protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
        private final JoinNode<C, ?> node;
        private final RowTransformer<C> rootRowTransformer;
        private final Set<SubPersisterConsumer<C, I>> subConsumers;
        @Nullable
        private final BiConsumer<C, ColumnedRow> consumptionListener;

        private JoinTablePolymorphicJoinRootRowConsumer(JoinNode<C, ?> node, RowTransformer<C> rootRowTransformer, Set<SubPersisterConsumer<C, I>> subConsumers, @Nullable BiConsumer<C, ColumnedRow> consumptionListener) {
            this.node = node;
            this.rootRowTransformer = rootRowTransformer;
            this.subConsumers = subConsumers;
            this.consumptionListener = consumptionListener;
        }

        public JoinNode<C, ?> getNode() {
            return this.node;
        }

        @Override
        public C createRootInstance(ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            Object result;
            Duo<I, SubPersisterConsumer<C, I>> subInflater = this.findSubInflater(row);
            if (subInflater == null) {
                CURRENTLY_FOUND_CONSUMER.remove();
                result = null;
            } else {
                CURRENTLY_FOUND_CONSUMER.set(((SubPersisterConsumer)subInflater.getRight()).subPropertiesApplier);
                result = context.giveEntityFromCache(((SubPersisterConsumer)subInflater.getRight()).subEntityType, subInflater.getLeft(), () -> {
                    this.LOGGER.debug("Instantiating entity of type {}", (Object)((SubPersisterConsumer)subInflater.getRight()).subEntityType);
                    ColumnedRow subInflaterRow = EntityTreeInflater.currentContext().getDecoder(((SubPersisterConsumer)subInflater.getRight()).subPropertiesApplier.getNode());
                    return ((SubPersisterConsumer)subInflater.getRight()).subEntityFactory.transform(subInflaterRow);
                });
                this.rootRowTransformer.applyRowToBean(row, result);
            }
            if (this.consumptionListener != null) {
                this.consumptionListener.accept(result, row);
            }
            return (C)result;
        }

        @Nullable
        public Duo<I, SubPersisterConsumer<C, I>> findSubInflater(ColumnedRow row) {
            for (SubPersisterConsumer<C, I> pawn : this.subConsumers) {
                ColumnedRow subInflaterRow = EntityTreeInflater.currentContext().getDecoder(((SubPersisterConsumer)pawn).subPropertiesApplier.getNode());
                Object assemble = ((SubPersisterConsumer)pawn).identifierAssembler.apply(subInflaterRow);
                if (assemble == null) continue;
                return new Duo(assemble, pawn);
            }
            return null;
        }

        @Override
        public Set<JoinRowConsumer> giveExcludedConsumers() {
            return this.subConsumers.stream().map(subConsumer -> ((SubPersisterConsumer)subConsumer).subPropertiesApplier).filter(consumerPawn -> CURRENTLY_FOUND_CONSUMER.get() != consumerPawn).collect(Collectors.toSet());
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }

    static class SubPersisterConsumer<C, I> {
        private Function<ColumnedRow, I> identifierAssembler;
        private final Class<C> subEntityType;
        private final RowTransformer<C> subEntityFactory;
        private MergeJoinNode.MergeJoinRowConsumer<C> subPropertiesApplier;

        private SubPersisterConsumer(Function<ColumnedRow, I> identifierAssembler, Class<C> subEntityType, RowTransformer<C> subEntityFactory) {
            this.identifierAssembler = identifierAssembler;
            this.subEntityType = subEntityType;
            this.subEntityFactory = subEntityFactory;
        }
    }
}

